/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.jwt;

import com.pageseeder.base.jwt.JWTException;
import com.pageseeder.common.net.URLCoder;
import jakarta.json.Json;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public final class OpenIdConfiguration {
    private static final String WELL_KNOWN_OPENID_CONFIGURATION = "/.well-known/openid-configuration";
    private final Map<String, Object> config;

    OpenIdConfiguration(Map<String, Object> config) {
        this.config = config;
    }

    public Object getValue(String key) {
        return this.config.get(key);
    }

    public String getJwksUri() {
        Object value = this.config.get("jwks_uri");
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static OpenIdConfiguration load(String authorityUrl) throws JWTException {
        return OpenIdConfiguration.loadFromURL(OpenIdConfiguration.urlForAuthority(authorityUrl, null));
    }

    public static OpenIdConfiguration loadMicrosoft(String authorityUrl, String appid) throws JWTException {
        return OpenIdConfiguration.loadFromURL(OpenIdConfiguration.urlForAuthority(authorityUrl, appid));
    }

    private static OpenIdConfiguration loadFromURL(URL url) throws JWTException {
        LoggerFactory.getLogger(OpenIdConfiguration.class).info("Loading OpenID configuration from {}", (Object)url);
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (connection.getResponseCode() != 200) {
                throw new JWTException("Unable to load openid-configuration from " + String.valueOf(url) + ": HTTP " + connection.getResponseCode());
            }
            return OpenIdConfiguration.parse(connection.getInputStream());
        }
        catch (IOException ex) {
            throw new JWTException("Unable to load openid-configuration from " + String.valueOf(url), ex);
        }
    }

    private static URL urlForAuthority(String authorityUrl, String appid) {
        String url = authorityUrl + WELL_KNOWN_OPENID_CONFIGURATION;
        if (appid != null) {
            url = url + "?appid=" + URLCoder.encode((String)appid);
        }
        try {
            URI uri = new URI(url).normalize();
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid jwks uri", ex);
        }
    }

    static OpenIdConfiguration parse(InputStream in) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        JsonParser.Event event = null;
        String name = null;
        ArrayList array = null;
        try (JsonParser parser = Json.createParser((InputStream)in);){
            block14: while (parser.hasNext()) {
                event = parser.next();
                switch (event) {
                    case KEY_NAME: {
                        name = parser.getString();
                        continue block14;
                    }
                    case VALUE_STRING: {
                        config.put(name, parser.getString());
                        continue block14;
                    }
                    case VALUE_NUMBER: {
                        config.put(name, parser.getLong());
                        continue block14;
                    }
                    case VALUE_TRUE: {
                        config.put(name, true);
                        continue block14;
                    }
                    case VALUE_FALSE: {
                        config.put(name, false);
                        continue block14;
                    }
                    case START_ARRAY: {
                        array = new ArrayList();
                        continue block14;
                    }
                    case END_ARRAY: {
                        config.put(name, array);
                        array = null;
                        continue block14;
                    }
                }
            }
        }
        return new OpenIdConfiguration(config);
    }
}

