/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.jwt;

import com.pageseeder.base.jwt.SigningKeyResolver;
import com.pageseeder.base.security.IdentityConfig;
import com.pageseeder.base.security.SecurityUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IDTokenValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IDTokenValidator.class);

    public @Nullable Claims validate(String token) {
        LOGGER.debug("Validating token {}", (Object)token);
        Claims claims = this.verify(token);
        if (claims != null) {
            String issuer;
            IdentityConfig config = SecurityUtils.getIdentityConfig();
            Set<String> audience = config.filterExternalProviders(issuer = claims.getIssuer(), claims.getAudience());
            if (audience.isEmpty()) {
                LOGGER.warn("Invalid `iss` ({}) or `aud` ({}) claim in ID token", (Object)issuer, (Object)claims.getAudience());
                return null;
            }
            String email = (String)claims.get("email", String.class);
            if (!config.allowsIDTokenForEmail(email)) {
                LOGGER.warn("Unsupported email domain: {}", (Object)email);
                return null;
            }
            if (!config.allowsProviderForEmail(email, issuer, audience)) {
                LOGGER.warn("Email domain {} cannot use specified provider {}", (Object)email, (Object)issuer);
                return null;
            }
            Date expiration = claims.getExpiration();
            if (expiration != null) {
                long toleranceMinutes = 3L;
                Instant expires = expiration.toInstant().plus(3L, ChronoUnit.MINUTES);
                if (expires.isBefore(Instant.now())) {
                    LOGGER.warn("ID token has expired");
                    return null;
                }
            }
        }
        return claims;
    }

    private @Nullable Claims verify(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKeyResolver((io.jsonwebtoken.SigningKeyResolver)new SigningKeyResolver()).build().parseSignedClaims((CharSequence)token).getPayload();
        }
        catch (JwtException ex) {
            LOGGER.error("Invalid ID token: {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }
}

