/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.generator;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.GeneratorErrors;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.RequireErrorID;
import com.pageseeder.base.generator.spi.BerliozAdaptor;
import com.pageseeder.db.DatabaseException;
import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.content.ContentStatus;
import org.pageseeder.xmlwriter.XMLWriter;

public interface Generator
extends ContentGenerator {
    public void process(GeneratorRequest var1, GeneratorResponse var2) throws GeneratorException, DatabaseException, IOException;

    default public void process(ContentRequest req, XMLWriter xml) throws BerliozException, IOException {
        ServiceLoader<BerliozAdaptor> loader = ServiceLoader.load(BerliozAdaptor.class);
        Iterator<BerliozAdaptor> adaptors = loader.iterator();
        if (adaptors.hasNext()) {
            BerliozAdaptor adaptor = adaptors.next();
            GeneratorRequest request = adaptor.toRequest(req);
            GeneratorResponse response = adaptor.toResponse(xml);
            ErrorID error = RequireErrorID.check(this, request);
            if (error != null) {
                xml.openElement("error");
                xml.attribute("id", GeneratorErrors.format(error.id()));
                xml.element("message", error.message());
                xml.closeElement();
                req.setStatus(ContentStatus.BAD_REQUEST);
            } else {
                try {
                    boolean hasPermission = adaptor.hasPermission(this, request);
                    if (hasPermission) {
                        this.process(request, response);
                        GeneratorStatus status = response.getStatus();
                        if (status == GeneratorStatus.ACCEPTED) {
                            req.setStatus(ContentStatus.ACCEPTED);
                        } else if (status == GeneratorStatus.CREATED) {
                            req.setStatus(ContentStatus.CREATED);
                        } else if (status == GeneratorStatus.BAD_REQUEST) {
                            req.setStatus(ContentStatus.BAD_REQUEST);
                        } else if (status == GeneratorStatus.SERVER_ERROR) {
                            req.setStatus(ContentStatus.INTERNAL_SERVER_ERROR);
                        }
                        error = response.getErrorID();
                        if (error != null) {
                            xml.openElement("error");
                            xml.attribute("id", GeneratorErrors.format(error.id()));
                            xml.element("message", response.getMessage());
                            xml.closeElement();
                        }
                    } else {
                        req.setStatus(ContentStatus.FORBIDDEN);
                    }
                }
                catch (GeneratorException | DatabaseException ex) {
                    throw new BerliozException("A generator or database exception occurred", (Exception)ex);
                }
                catch (Exception ex) {
                    req.setAttribute("javax.servlet.error.exception", (Object)ex);
                    req.setAttribute("javax.servlet.error.exception_type", ex.getClass());
                    throw ex;
                }
            }
        }
    }
}

