/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.document.PSMLContentBuilder;
import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.util.Strings;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PSMLFragmentLoader
extends DefaultHandler
implements PSMLContentBuilder.FragmentDetailsLoader {
    private final Map<String, FragmentDetails> fragments = new HashMap<String, FragmentDetails>();
    private String currentFragID = null;
    private XMLWriter myOutput = null;
    private boolean inLocator = false;
    private boolean inNotes = false;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    protected int inMediaFragment = 0;
    private String structureModified = null;

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
        if (this.myOutput != null) {
            this.myOutput.setPrefixMapping(uri, prefix);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.namespaces.remove(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String modified;
        if (PSMLContentUtils.isFragmentElement(localName) && !"true".equals(atts.getValue("deleted")) && this.inMediaFragment == 0) {
            this.currentFragID = atts.getValue("id");
            this.myOutput = new XMLStringWriter(XML.NamespaceAware.Yes);
            for (String prefix : this.namespaces.keySet()) {
                this.myOutput.setPrefixMapping(this.namespaces.get(prefix), prefix);
            }
        } else if ("locator".equals(localName) && this.inMediaFragment == 0) {
            this.inLocator = true;
            this.currentFragID = atts.getValue("fragment");
            if (this.currentFragID != null) {
                FragmentDetails details = new FragmentDetails();
                String modified2 = atts.getValue("modified");
                if (!Strings.isEmpty((String)modified2)) {
                    details.modified = modified2;
                }
                this.fragments.put(this.currentFragID, details);
            }
        } else if (this.inLocator && "notes".equals(localName) && this.inMediaFragment == 0) {
            this.myOutput = new XMLStringWriter(XML.NamespaceAware.Yes);
            for (String prefix : this.namespaces.keySet()) {
                this.myOutput.setPrefixMapping(this.namespaces.get(prefix), prefix);
            }
            this.inNotes = true;
        } else if ("fragmentinfo".equals(localName) && this.inMediaFragment == 0 && !Strings.isEmpty((String)(modified = atts.getValue("structure-modified")))) {
            this.structureModified = modified;
        }
        if (this.myOutput != null) {
            try {
                this.myOutput.openElement(Strings.isEmpty((String)uri) ? null : uri, localName, true);
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (this.inLocator && "note".equals(localName) && "id".equals(atts.getLocalName(i))) continue;
                    this.myOutput.attribute(Strings.isEmpty((String)atts.getURI(i)) ? null : atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open element " + localName, ex);
            }
        }
        if (this.inLocator && !this.inNotes && "labels".equals(localName) && this.inMediaFragment == 0) {
            this.myOutput = new XMLStringWriter(XML.NamespaceAware.Yes);
            for (String prefix : this.namespaces.keySet()) {
                this.myOutput.setPrefixMapping(this.namespaces.get(prefix), prefix);
            }
        }
        if (PSMLContentUtils.isMediaFragmentElement(localName)) {
            ++this.inMediaFragment;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.myOutput != null) {
            try {
                this.myOutput.writeText(ch, start, length);
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write text", ex);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (PSMLContentUtils.isMediaFragmentElement(localName)) {
            --this.inMediaFragment;
        }
        if (this.inLocator && !this.inNotes && "labels".equals(localName) && this.currentFragID != null && this.inMediaFragment == 0) {
            String labels = this.myOutput.toString();
            this.myOutput = null;
            if (!labels.isEmpty()) {
                FragmentDetails details = this.fragments.get(this.currentFragID);
                details.labels = labels;
            }
        }
        if (this.myOutput != null) {
            FragmentDetails details;
            try {
                this.myOutput.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to close element " + localName, ex);
            }
            if (PSMLContentUtils.isFragmentElement(localName) && this.currentFragID != null && this.inMediaFragment == 0) {
                details = this.fragments.get(this.currentFragID);
                if (details == null) {
                    details = new FragmentDetails();
                }
                details.xmlContent = this.myOutput.toString();
                this.fragments.put(this.currentFragID, details);
                this.myOutput = null;
                this.currentFragID = null;
            } else if (this.inLocator && "notes".equals(localName) && this.currentFragID != null && this.inMediaFragment == 0) {
                details = this.fragments.get(this.currentFragID);
                details.xmlNotes = this.myOutput.toString();
                this.myOutput = null;
                this.inNotes = false;
            }
        } else if ("locator".equals(localName) && this.inMediaFragment == 0) {
            this.inLocator = false;
            this.currentFragID = null;
        }
    }

    @Override
    public final String getFragmentContent(String fragment) {
        FragmentDetails details = this.fragments.get(fragment);
        return details == null || details.xmlContent == null || details.xmlContent.isEmpty() ? null : details.xmlContent;
    }

    @Override
    public final String getLocatorContent(String fragment) {
        FragmentDetails details = this.fragments.get(fragment);
        if (details == null) {
            return null;
        }
        if (details.labels == null) {
            return details.xmlNotes;
        }
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            xml.element("labels", details.labels);
            if (details.xmlNotes != null) {
                xml.writeXML(details.xmlNotes);
            }
        }
        catch (IOException ex) {
            throw new UnforeseenException((Throwable)ex);
        }
        return xml.toString();
    }

    @Override
    public final String getLabels(String fragment) {
        FragmentDetails details = this.fragments.get(fragment);
        if (details == null) {
            return null;
        }
        return details.labels;
    }

    @Override
    public final String getModifiedDate(String fragment) {
        FragmentDetails details = this.fragments.get(fragment);
        if (details == null) {
            return null;
        }
        return details.modified;
    }

    @Override
    public final String getStructureModifiedDate() {
        return this.structureModified;
    }

    @Override
    public final Collection<String> getFragments() {
        return this.fragments.keySet();
    }

    private static class FragmentDetails {
        String xmlContent;
        protected String labels;
        protected String modified;
        String xmlNotes;

        private FragmentDetails() {
        }
    }
}

