/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.document.PSMLContentBuilder;
import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.document.PSMLFragmentLoader;
import com.pageseeder.common.util.Strings;
import java.io.IOException;
import java.util.ArrayDeque;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class PSMLContentHandler
extends PSMLFragmentLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSMLContentHandler.class);
    private XMLWriter output;
    private XMLWriter temporaryXML;
    private String currentFragmentID = null;
    private final PSMLContentBuilder psmlBuilder;
    private String fragment = null;
    private boolean ignore = false;
    private boolean deleted = false;
    private boolean firstSectionGone = false;
    private ArrayDeque<String> elements = new ArrayDeque();

    PSMLContentHandler(PSMLContentBuilder builder, XMLWriter xml) {
        this.output = xml;
        this.psmlBuilder = builder;
    }

    public void setFragment(String frag) {
        this.fragment = frag;
        this.ignore = this.fragment != null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        super.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        boolean isSection = "section".equals(localName);
        if ("documentinfo".equals(localName) || "fragmentinfo".equals(localName) || "metadata".equals(localName) || (isSection || "toc".equals(localName)) && this.fragment != null) {
            this.ignore = true;
        } else if ((isSection || "toc".equals(localName)) && !this.firstSectionGone && this.fragment == null) {
            this.firstSectionGone = true;
            this.temporaryXML = new XMLStringWriter(XML.NamespaceAware.Yes);
        } else if (PSMLContentUtils.isFragmentElement(localName) && !this.ignore) {
            this.ignore = true;
            this.deleted = "true".equals(attributes.getValue("deleted"));
            this.currentFragmentID = attributes.getValue("id");
            if (this.currentFragmentID == null) {
                LOGGER.error("Invalid fragment has no 'id' attribute");
                throw new SAXException("Invalid fragment has no 'id' attribute");
            }
        }
        if (!this.ignore) {
            try {
                if ("document".equals(localName)) {
                    this.psmlBuilder.document(attributes, this.currentOutput());
                } else {
                    this.currentOutput().openElement(Strings.isEmpty((String)uri) ? null : uri, localName, true);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.currentOutput().attribute(Strings.isEmpty((String)attributes.getURI(i)) ? null : attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to output PSML content start element {}", (Object)localName, (Object)ex);
                throw new SAXException("Failed to output PSML content start element " + localName, ex);
            }
        }
        this.elements.push(localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elements.pop();
        super.endElement(uri, localName, qName);
        if (!this.ignore && !"document".equals(localName)) {
            try {
                this.currentOutput().closeElement();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to output PSML content end element {}", (Object)localName, (Object)ex);
                throw new SAXException("Failed to output PSML content end element " + localName, ex);
            }
        }
        if (PSMLContentUtils.isFragmentElement(localName) && this.currentFragmentID != null) {
            if ((this.fragment == null || this.currentFragmentID.equals(this.fragment)) && !this.deleted) {
                try {
                    this.psmlBuilder.fragment(this.currentFragmentID, this, true, false, this.currentOutput());
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to output fragment {}", (Object)this.currentFragmentID, (Object)ex);
                    throw new SAXException("Failed to output fragment " + this.currentFragmentID, ex);
                }
            }
            this.currentFragmentID = null;
            this.ignore = false;
        }
        if ("documentinfo".equals(localName) || "fragmentinfo".equals(localName) || "metadata".equals(localName) && "document".equals(this.elements.peek())) {
            this.ignore = false;
        } else if (this.fragment != null && PSMLContentUtils.isFragmentElement(localName)) {
            this.ignore = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (!this.ignore) {
            try {
                this.currentOutput().writeText(ch, start, length);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to output text content", (Throwable)ex);
                throw new SAXException("Failed to output text content", ex);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.psmlBuilder.documentInfo(this.output);
            this.psmlBuilder.fragmentInfo(this.output, this);
            this.psmlBuilder.metadata(this.output, this);
            if (this.temporaryXML == null) {
                throw new SAXException("PSML document is not valid for URI ID: " + this.psmlBuilder.getURI().getId());
            }
            this.output.writeXML(this.temporaryXML.toString());
            this.output.closeElement();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to output entire content", (Throwable)ex);
            throw new SAXException("Failed to output entire content", ex);
        }
    }

    private XMLWriter currentOutput() {
        return this.temporaryXML == null ? this.output : this.temporaryXML;
    }
}

