/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.PSMLContentBuilder;
import com.pageseeder.base.document.PSMLContentHandler;
import com.pageseeder.base.document.PSMLStructureHandler;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.rule.InternalURIFetcher;
import com.pageseeder.base.rule.URIFetcherStatus;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentTracker.class);
    private final Database db;
    private final Transaction tr;
    private final URI uri;
    private final Group group;
    private boolean trackOriginal = false;
    private long compareId = -1L;
    private long versionId = -1L;

    public DocumentTracker(URI u, Group g, Database db, Transaction tr, boolean original) {
        this.uri = u;
        this.group = g;
        this.db = db;
        this.tr = tr;
        this.trackOriginal = original;
    }

    public void setLimitIds(long compareid, long versionid) {
        this.compareId = compareid;
        this.versionId = versionid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(XMLWriter output) throws QueryFailedException, URIException, IOException {
        XMLStringWriter psml;
        block13: {
            InternalURIFetcher fetcher = new InternalURIFetcher(this.uri, null);
            if (fetcher.getStatus() != URIFetcherStatus.SUCCESS) {
                throw new URIException("URIFetcher Status: " + String.valueOf((Object)fetcher.getStatus()) + " Message: " + fetcher.getStatusMessage());
            }
            PSMLContentBuilder builder = new PSMLContentBuilder(this.uri, this.group, this.db);
            builder.setTransaction(this.tr);
            builder.setTrack(true);
            builder.setCompareId(this.compareId);
            if (this.trackOriginal) {
                builder.setTrackOriginal();
            }
            if (this.versionId == 0L) {
                builder.setOriginalVersion();
            } else if (this.versionId > 0L) {
                builder.setVersion(DatabaseQuery.getXLinkById((Database)this.db, (Long)this.versionId));
            }
            psml = new XMLStringWriter(XML.NamespaceAware.Yes);
            try {
                XLink structure = DatabaseQuery.getXLinkURIStructure((Database)this.db, (URI)this.uri, (Group)this.group, (Date)(this.versionId == 0L ? this.uri.getDateCreated() : null), (long)this.versionId, (boolean)false);
                if (structure == null) {
                    try {
                        XMLHelpers.parse(fetcher.getContent(), new PSMLContentHandler(builder, (XMLWriter)psml));
                        break block13;
                    }
                    catch (FoundationException | IOException ex) {
                        LOGGER.error("Failed to parse original XML: {}", (Object)ex.getMessage(), (Object)ex);
                        throw new URIException(ex);
                    }
                }
                String structureContent = ((Content)structure.getContents().next()).getData();
                PSMLStructureHandler handler = new PSMLStructureHandler(builder, (XMLWriter)psml, fetcher);
                try {
                    XMLHelpers.parse(new ByteArrayInputStream(structureContent.getBytes(StandardCharsets.UTF_8)), handler);
                }
                catch (FoundationException ex) {
                    LOGGER.error("Failed to parse structure XML: {}", (Object)ex.getMessage(), (Object)ex);
                    throw new URIException(ex);
                }
            }
            finally {
                fetcher.close();
            }
        }
        output.writeXML(psml.toString());
    }
}

