/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.label.LabelConfig;
import com.pageseeder.base.label.LabelInfo;
import com.pageseeder.base.label.LabelType;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.Role;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentConfigHandler
extends DefaultHandler {
    private static final String CREATION_ELEMENT = "creation";
    private static final String DISABLED_ATTRIBUTE = "disabled";
    private static final String EDITING_ELEMENT = "editing";
    private static final String EDITOR_ELEMENT = "editor";
    private static final String LABELING_ELEMENT = "labeling";
    private static final String LABELS_ELEMENT = "labels";
    private static final String LABEL_ELEMENT = "label";
    private static final String ROLES_ELEMENT = "roles";
    private static final String ROLE_ELEMENT = "role";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String FRAG_TYPES_ATTRIBUTE = "fragmenttypes";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String PUBLISHING_ELEMENT = "publishing";
    private static final String OVERRIDE_ATTRIBUTE = "override";
    private static final String ACTION_ELEMENT = "action";
    private static final String TARGET_ELEMENT = "target";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SOURCE_ELEMENT = "source";
    private static final String EXTENSION_ATTRIBUTE = "extension";
    private static final String DOCUMENT_TYPE_ATTRIBUTE = "document-type";
    private static final String COLOR_ATTRIBUTE = "color";
    private XMLWriter xml = null;
    private boolean inPublishing = true;
    private boolean creationFound = false;
    private boolean overrideLabeling = false;
    private boolean overridePublishing = false;
    private boolean overrideEditing = false;
    private List<String> overrideTargets = new ArrayList<String>();
    private PublishAction currentAction = null;
    private LabelType currentLabelType = null;
    private List<PublishAction> actions;
    private LabelConfig myLabels = null;
    private String creation;
    private String currentTargetRole = null;
    private List<String> editing;
    private List<String> roles = new ArrayList<String>();
    private LabelConfig labelConfig;
    private boolean isDocumentConfig = false;
    private final String doctype;

    DocumentConfigHandler() {
        this(null, null, null);
    }

    DocumentConfigHandler(List<String> overrideTargets) {
        this(null, null, overrideTargets);
    }

    public DocumentConfigHandler(LabelConfig labels, String documenttype) {
        this(labels, documenttype, null);
    }

    DocumentConfigHandler(LabelConfig labels, String documenttype, List<String> overrideTargets) {
        this.doctype = documenttype;
        this.creation = null;
        this.editing = new ArrayList<String>();
        this.actions = new ArrayList<PublishAction>();
        this.labelConfig = labels == null ? null : new LabelConfig(labels);
        this.overrideTargets = overrideTargets == null ? new ArrayList<String>() : new ArrayList<String>(overrideTargets);
    }

    @Override
    public void startDocument() {
        this.creation = null;
    }

    boolean creationWasFound() {
        return this.creationFound;
    }

    boolean overridePublishing() {
        return this.overridePublishing;
    }

    boolean overrideLabeling() {
        return this.overrideLabeling;
    }

    public List<String> overrideTargets() {
        return this.overrideTargets;
    }

    void setOverrideTargets(List<String> targets) {
        this.overrideTargets = new ArrayList<String>(targets);
    }

    public String getCreation() {
        return this.creation;
    }

    List<PublishAction> getPublishActions() {
        return this.actions;
    }

    public List<String> getEditing() {
        return this.editing;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    LabelConfig getLabelConfig() {
        return this.labelConfig;
    }

    @Override
    public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
        String name;
        if ("document-config".equals(lName)) {
            this.isDocumentConfig = true;
        }
        if (CREATION_ELEMENT.equals(lName)) {
            this.creationFound = true;
            if (!"true".equals(atts.getValue(DISABLED_ATTRIBUTE))) {
                this.xml = new XMLStringWriter(XML.NamespaceAware.No);
            } else {
                this.creation = "";
            }
        } else if (EDITING_ELEMENT.equals(lName)) {
            this.overrideEditing = "true".equals(atts.getValue(OVERRIDE_ATTRIBUTE));
            if (this.overrideEditing) {
                this.editing.clear();
            }
        } else if (EDITOR_ELEMENT.equals(lName)) {
            this.xml = new XMLStringWriter(XML.NamespaceAware.No);
        } else if (PUBLISHING_ELEMENT.equals(lName)) {
            this.inPublishing = true;
            this.overridePublishing = "true".equals(atts.getValue(OVERRIDE_ATTRIBUTE));
            if (this.overridePublishing) {
                this.actions.clear();
            }
        } else if (this.inPublishing && ACTION_ELEMENT.equals(lName)) {
            this.currentAction = new PublishAction();
            this.currentAction.type = atts.getValue(TYPE_ATTRIBUTE);
            if (this.isDocumentConfig) {
                this.currentAction.setSource("document", "psml", Strings.isEmpty((String)this.doctype) ? "default" : this.doctype);
            }
        } else if (this.currentAction != null && TARGET_ELEMENT.equals(lName)) {
            name = atts.getValue(NAME_ATTRIBUTE);
            if (!this.overrideTargets.contains(this.currentAction.type + ":" + name)) {
                this.xml = new XMLStringWriter(XML.NamespaceAware.No);
                this.currentTargetRole = atts.getValue(ROLE_ELEMENT);
                String override = atts.getValue(OVERRIDE_ATTRIBUTE);
                if ("true".equals(override)) {
                    this.overrideTargets.add(this.currentAction.type + ":" + name);
                }
            }
        } else if (this.currentAction != null && SOURCE_ELEMENT.equals(lName)) {
            this.currentAction.setSource(atts.getValue(TYPE_ATTRIBUTE), atts.getValue(EXTENSION_ATTRIBUTE), atts.getValue(DOCUMENT_TYPE_ATTRIBUTE));
        } else if (LABELING_ELEMENT.equals(lName)) {
            this.overrideLabeling = "true".equals(atts.getValue(OVERRIDE_ATTRIBUTE));
            if (this.labelConfig == null || this.overrideLabeling) {
                this.labelConfig = new LabelConfig("");
            }
        } else if (LABELS_ELEMENT.equals(lName)) {
            this.currentLabelType = LabelType.valueOf(atts.getValue(TYPE_ATTRIBUTE).toUpperCase().replace('-', '_'));
        } else if (this.labelConfig != null && this.currentLabelType != null && LABEL_ELEMENT.equals(lName)) {
            name = atts.getValue(NAME_ATTRIBUTE);
            String description = atts.getValue(DESCRIPTION_ATTRIBUTE);
            String color = atts.getValue(COLOR_ATTRIBUTE);
            String fragmenttypes = atts.getValue(FRAG_TYPES_ATTRIBUTE);
            LabelInfo label = new LabelInfo(name, description, fragmenttypes);
            label.setColor(color);
            if (this.myLabels == null) {
                this.myLabels = new LabelConfig("");
            }
            this.myLabels.add(this.currentLabelType, label, false);
        } else if (ROLES_ELEMENT.equals(lName)) {
            this.roles.clear();
        } else if (ROLE_ELEMENT.equals(lName)) {
            this.xml = new XMLStringWriter(XML.NamespaceAware.No);
        }
        if (this.xml != null) {
            try {
                this.xml.openElement(lName);
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.xml.attribute(atts.getLocalName(i), atts.getValue(i));
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open element " + lName, ex);
            }
        }
    }

    @Override
    public void endElement(String uri, String lName, String qName) throws SAXException {
        if (this.xml != null) {
            try {
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to close element " + lName, ex);
            }
        }
        if (CREATION_ELEMENT.equals(lName)) {
            if (this.xml != null) {
                this.creation = this.xml.toString();
            }
            this.xml = null;
        } else if (PUBLISHING_ELEMENT.equals(lName)) {
            this.inPublishing = false;
        } else if (LABELING_ELEMENT.equals(lName)) {
            if (this.myLabels != null) {
                this.labelConfig.addAll(this.myLabels);
            }
        } else if (EDITOR_ELEMENT.equals(lName)) {
            if (this.xml != null) {
                this.editing.add(this.xml.toString());
            }
            this.xml = null;
        } else if (ROLE_ELEMENT.equals(lName)) {
            if (this.xml != null) {
                this.roles.add(this.xml.toString());
            }
            this.xml = null;
        } else if (this.currentAction != null && ACTION_ELEMENT.equals(lName)) {
            this.actions.add(this.currentAction);
            this.currentAction = null;
        } else if (this.currentAction != null && TARGET_ELEMENT.equals(lName) && this.xml != null) {
            this.currentAction.addTarget(this.xml.toString(), this.currentTargetRole);
            this.xml = null;
            this.currentTargetRole = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.xml != null) {
            try {
                this.xml.writeText(ch, start, length);
            }
            catch (IOException ex) {
                throw new SAXException("Failed to write text", ex);
            }
        }
    }

    public void toXML(XMLWriter output, Role role) throws IOException {
        if (this.isDocumentConfig) {
            output.openElement("document-config");
            if (this.creation != null) {
                output.writeXML(this.creation);
            }
            output.openElement(EDITING_ELEMENT);
            if (this.overrideEditing) {
                output.attribute(OVERRIDE_ATTRIBUTE, "true");
            }
            for (String editor : this.editing) {
                output.writeXML(editor);
            }
            output.closeElement();
            output.openElement(LABELING_ELEMENT);
            if (this.overrideLabeling) {
                output.attribute(OVERRIDE_ATTRIBUTE, "true");
            }
            for (LabelType type : this.labelConfig.getTypes()) {
                output.openElement(LABELS_ELEMENT);
                output.attribute(TYPE_ATTRIBUTE, type.key());
                for (LabelInfo info : this.labelConfig.getLabelInfos(type)) {
                    output.openElement(LABEL_ELEMENT);
                    output.attribute(NAME_ATTRIBUTE, info.name());
                    if (info.description() != null) {
                        output.attribute(DESCRIPTION_ATTRIBUTE, info.description());
                    }
                    if (info.fragmenttypes() != null) {
                        output.attribute(FRAG_TYPES_ATTRIBUTE, info.fragmenttypes());
                    }
                    if (info.getColor() != null) {
                        output.attribute(COLOR_ATTRIBUTE, info.getColor());
                    }
                    output.closeElement();
                }
                output.closeElement();
            }
            output.closeElement();
        }
        output.openElement(ROLES_ELEMENT);
        for (String r : this.roles) {
            output.writeXML(r);
        }
        output.closeElement();
        output.openElement(PUBLISHING_ELEMENT);
        if (this.overridePublishing) {
            output.attribute(OVERRIDE_ATTRIBUTE, "true");
        }
        for (PublishAction action : this.actions) {
            action.toXML(output, role);
        }
        output.closeElement();
        if (this.isDocumentConfig) {
            output.closeElement();
        }
    }

    public static class PublishAction {
        private String type;
        private Map<String, String> source = new HashMap<String, String>();
        private List<String> targets = new ArrayList<String>();
        private Map<String, Role> targetRoles = new HashMap<String, Role>();

        public String toString() {
            return this.type;
        }

        public String getType() {
            return this.type;
        }

        void addTarget(String xml, String role) {
            Role r;
            this.targets.add(xml);
            Object object = "manager".equals(role) ? Role.MANAGER : ("contributor".equals(role) ? Role.CONTRIBUTOR : (r = "approver".equals(role) ? Role.APPROVER : null));
            if (r != null) {
                this.targetRoles.put(xml, r);
            }
        }

        void setSource(String stype, String extension, String doctype) {
            if (!Strings.isEmpty((String)stype)) {
                this.source.put(DocumentConfigHandler.TYPE_ATTRIBUTE, stype);
                if (!Strings.isEmpty((String)extension)) {
                    this.source.put(DocumentConfigHandler.EXTENSION_ATTRIBUTE, extension);
                }
                if (!Strings.isEmpty((String)doctype)) {
                    this.source.put(DocumentConfigHandler.DOCUMENT_TYPE_ATTRIBUTE, doctype);
                }
            }
        }

        public void toXML(XMLWriter xml, Role role) throws IOException {
            ArrayList<String> tempTargets = new ArrayList<String>();
            for (String target : this.targets) {
                Role targetRole = this.targetRoles.get(target);
                if (targetRole != null && role != null && targetRole != role && !this.firstHigherOrEquals(role, targetRole)) continue;
                tempTargets.add(target);
            }
            if (tempTargets.isEmpty()) {
                return;
            }
            xml.openElement(DocumentConfigHandler.ACTION_ELEMENT);
            xml.attribute(DocumentConfigHandler.TYPE_ATTRIBUTE, this.type);
            if (this.source.containsKey(DocumentConfigHandler.TYPE_ATTRIBUTE)) {
                xml.openElement(DocumentConfigHandler.SOURCE_ELEMENT);
                xml.attribute(DocumentConfigHandler.TYPE_ATTRIBUTE, this.source.get(DocumentConfigHandler.TYPE_ATTRIBUTE));
                if (this.source.containsKey(DocumentConfigHandler.EXTENSION_ATTRIBUTE)) {
                    xml.attribute(DocumentConfigHandler.EXTENSION_ATTRIBUTE, this.source.get(DocumentConfigHandler.EXTENSION_ATTRIBUTE));
                }
                if (this.source.containsKey(DocumentConfigHandler.DOCUMENT_TYPE_ATTRIBUTE)) {
                    xml.attribute(DocumentConfigHandler.DOCUMENT_TYPE_ATTRIBUTE, this.source.get(DocumentConfigHandler.DOCUMENT_TYPE_ATTRIBUTE));
                }
                xml.closeElement();
            }
            for (String target : tempTargets) {
                xml.writeXML(target);
            }
            xml.closeElement();
        }

        private boolean firstHigherOrEquals(Role first, Role second) {
            if (first == Role.APPROVER) {
                return true;
            }
            if (first == Role.MANAGER && second != Role.APPROVER) {
                return true;
            }
            return first == Role.CONTRIBUTOR && second != Role.APPROVER && second != Role.MANAGER;
        }

        boolean matchesSource(String type, String ext, String dtype) {
            String extension;
            if (type == null) {
                return true;
            }
            if (!type.equals(this.source.get(DocumentConfigHandler.TYPE_ATTRIBUTE))) {
                return false;
            }
            if (ext != null && !ext.equals(extension = this.source.get(DocumentConfigHandler.EXTENSION_ATTRIBUTE))) {
                return false;
            }
            if (dtype != null) {
                String documenttype = this.source.get(DocumentConfigHandler.DOCUMENT_TYPE_ATTRIBUTE);
                if (documenttype == null) {
                    return true;
                }
                return documenttype.equals(dtype);
            }
            return true;
        }
    }
}

