/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.diff;

import com.pageseeder.base.diff.OriginAttributes;
import com.pageseeder.base.diff.OriginReference;
import com.pageseeder.base.diff.TrackedSequence;
import com.pageseeder.base.diff.TrackedToken;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.diffx.DiffException;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.token.AttributeToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.XMLAttribute;
import org.pageseeder.diffx.xml.Namespace;
import org.pageseeder.diffx.xml.NamespaceSet;

public class TrackerXMLOutput<T> {
    private static final String DIFF_NS_URI = "https://www.pageseeder.org/diffx";
    private static final String TRACKER_NS_URI = "https://www.pageseeder.org/diffx/track";
    private static final Namespace DIFF_NS = new Namespace("https://www.pageseeder.org/diffx", "diff");
    private static final Namespace TRACKER_NS = new Namespace("https://www.pageseeder.org/diffx/track", "track");
    private OriginReference<T> reference = Object::toString;
    private OriginAttributes<T> textFormat = origin -> Collections.singletonList(new XMLAttribute("origin", origin.toString()));
    private boolean includeXMLDeclaration = false;
    private final XMLStreamWriter xml;
    private boolean declareNamespace = true;
    private final Map<T, List<AttributeToken>> attributesCache = new HashMap<T, List<AttributeToken>>();
    private String element = "span";

    public TrackerXMLOutput(Writer w) {
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        output.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        try {
            this.xml = output.createXMLStreamWriter(w);
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public TrackerXMLOutput(OutputStream out) {
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        output.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        try {
            this.xml = output.createXMLStreamWriter(out);
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setElement(Operator operator) {
        this.element = TrackerXMLOutput.toElement(operator);
    }

    private static String toElement(Operator operator) {
        switch (operator) {
            case DEL: {
                return "del";
            }
            case INS: {
                return "ins";
            }
        }
        return "span";
    }

    public OriginAttributes<T> getTextFormat() {
        return this.textFormat;
    }

    public void setTextFormat(OriginAttributes<T> textFormat) {
        this.textFormat = textFormat;
    }

    public void setReference(OriginReference<T> reference) {
        this.reference = reference;
    }

    public final void setWriteXMLDeclaration(boolean show) {
        this.includeXMLDeclaration = show;
    }

    public void write(TrackedSequence<T> sequence) throws DiffException {
        NamespaceSet namespaces = NamespaceSet.noNamespace();
        namespaces.add(DIFF_NS);
        namespaces.add(TRACKER_NS);
        namespaces.add(sequence.getNamespaces());
        try {
            this.start(namespaces);
            for (TrackedToken trackedToken : sequence) {
                this.write(trackedToken);
            }
            this.attributesCache.clear();
        }
        catch (XMLStreamException ex) {
            throw new DiffException((Exception)ex);
        }
    }

    private void start(NamespaceSet namespaces) throws XMLStreamException {
        if (this.includeXMLDeclaration) {
            this.xml.writeStartDocument("utf-8", "1.0");
        }
        for (Namespace namespace : namespaces) {
            String uri = namespace.getUri();
            if (uri.isEmpty()) continue;
            this.xml.setPrefix(namespace.getPrefix(), uri);
        }
    }

    private void write(TrackedToken<T> token) throws XMLStreamException {
        if (token.getType() == XMLTokenType.START_ELEMENT) {
            token.toXML(this.xml);
            if (this.declareNamespace) {
                this.xml.writeNamespace(DIFF_NS.getPrefix(), DIFF_NS.getUri());
                this.xml.writeNamespace(TRACKER_NS.getPrefix(), TRACKER_NS.getUri());
                this.declareNamespace = false;
            }
            if (token.getOrigin() != null) {
                String ref = this.reference.getReference(token.getOrigin());
                if ("ins".equals(this.element)) {
                    this.xml.writeAttribute(DIFF_NS_URI, "insert", ref);
                } else if ("del".equals(this.element)) {
                    this.xml.writeAttribute(DIFF_NS_URI, "delete", ref);
                }
            }
        } else if (token.getType() == XMLTokenType.TEXT) {
            if (token.getOrigin() != null) {
                this.xml.writeStartElement(TRACKER_NS_URI, this.element);
                for (AttributeToken attribute : this.getAttributes(token.getOrigin())) {
                    this.xml.writeAttribute(attribute.getName(), attribute.getValue());
                }
                token.toXML(this.xml);
                this.xml.writeEndElement();
            } else {
                token.toXML(this.xml);
            }
        } else if (token.getType() == XMLTokenType.ATTRIBUTE) {
            token.toXML(this.xml);
            if (token.getOrigin() != null && token.getNamespaceURI().isEmpty()) {
                String ref = this.reference.getReference(token.getOrigin());
                this.xml.writeAttribute(TRACKER_NS_URI, token.getName(), ref);
            }
        } else {
            token.toXML(this.xml);
        }
        this.xml.flush();
    }

    private List<AttributeToken> getAttributes(T origin) {
        return this.attributesCache.computeIfAbsent(origin, o -> this.textFormat.attributes(o));
    }
}

