/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.diff;

import com.pageseeder.base.diff.PSMLDiffUtils;
import com.pageseeder.base.diff.TrackedContent;
import com.pageseeder.base.diff.TrackedSequence;
import com.pageseeder.base.diff.TrackedToken;
import com.pageseeder.base.diff.TrackedTokens;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pageseeder.diffx.DiffException;
import org.pageseeder.diffx.algorithm.KumarRanganAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.config.DiffConfig;
import org.pageseeder.diffx.load.SAXLoader;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.xml.NamespaceSet;
import org.pageseeder.diffx.xml.Sequence;
import org.pageseeder.psml.diff.PSMLWhiteSpaceStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginTracker<T> {
    private boolean coalesce = true;
    private DiffConfig config = DiffConfig.getDefault();
    private static final Logger LOGGER = LoggerFactory.getLogger(OriginTracker.class);

    public void setCoalesce(boolean coalesce) {
        this.coalesce = coalesce;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public DiffConfig getConfig() {
        return this.config;
    }

    public void setConfig(DiffConfig config) {
        this.config = config;
    }

    public TrackedSequence<T> track(List<TrackedContent<T>> history) throws DiffException {
        SAXLoader loader = new SAXLoader();
        loader.setConfig(this.config);
        KumarRanganAlgorithm algorithm = new KumarRanganAlgorithm();
        List previous = Collections.emptyList();
        NamespaceSet namespaces = NamespaceSet.noNamespace();
        for (TrackedContent<T> change : history) {
            String content = change.getContent();
            try {
                Sequence sequence = loader.load(content);
                int size = sequence.size();
                PSMLWhiteSpaceStripper stripper = new PSMLWhiteSpaceStripper();
                sequence = stripper.process(sequence);
                sequence = PSMLDiffUtils.untokenize(sequence, Arrays.asList("value", "xref", "blockxref"));
                LOGGER.debug("{} reduced to {} after stripping/untokenizing", (Object)size, (Object)sequence.size());
                namespaces = sequence.getNamespaces();
                List<TrackedToken<T>> tokens = TrackedTokens.track((List<XMLToken>)sequence, change.getOrigin());
                TrackHandler handler = new TrackHandler();
                algorithm.diff(previous, tokens, handler);
                previous = handler.getTokens();
            }
            catch (Exception ex) {
                LOGGER.error("Error tracking changes on content: {}", (Object)content);
                throw ex;
            }
        }
        if (this.coalesce) {
            previous = TrackedTokens.coalesce(previous);
        }
        return new TrackedSequence(namespaces, previous);
    }

    public TrackedSequence<T> track(List<TrackedContent<T>> history, boolean complete) throws DiffException {
        List<TrackedContent<T>> actual = history;
        if (!complete) {
            actual = new ArrayList<TrackedContent<T>>(history);
            actual.set(0, new TrackedContent<Object>(history.get(0).getContent(), null));
        }
        return this.track(actual);
    }

    public TrackedSequence<T> trackReverse(List<TrackedContent<T>> history) throws DiffException {
        ArrayList<TrackedContent<T>> reverse = new ArrayList<TrackedContent<T>>(history.size());
        for (int i = history.size() - 1; i >= 0; --i) {
            String content = history.get(i).getContent();
            TrackedContent<T> next = i < history.size() - 1 ? history.get(i + 1) : null;
            reverse.add(new TrackedContent<Object>(content, (next != null ? (Object)next.getOrigin() : null)));
        }
        return this.track(reverse);
    }

    private static class TrackHandler<T>
    implements DiffHandler<TrackedToken<T>> {
        List<TrackedToken<T>> tokens = new ArrayList<TrackedToken<T>>();
        final Operator discard = Operator.DEL;

        private TrackHandler() {
        }

        public void handle(Operator operator, TrackedToken<T> token) {
            if (operator != this.discard) {
                this.tokens.add(token);
            }
        }

        public List<TrackedToken<T>> getTokens() {
            return this.tokens;
        }
    }
}

