/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.diff;

import com.pageseeder.base.diff.TrackedSequence;
import com.pageseeder.base.diff.TrackedToken;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.diffx.DiffException;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.xml.Namespace;
import org.pageseeder.diffx.xml.NamespaceSet;

public class DiffXMLOutput<T> {
    private static final Namespace DIFF_NS = new Namespace("https://www.pageseeder.org/diffx", "diff");
    private static final Namespace DEL_NS = new Namespace("https://www.pageseeder.org/diffx/delete", "del");
    private static final Namespace INS_NS = new Namespace("https://www.pageseeder.org/diffx/insert", "ins");
    private boolean includeXMLDeclaration = false;
    private final XMLStreamWriter xml;
    private boolean declareNamespace = true;
    private Operator operator;

    public DiffXMLOutput(Writer w) {
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        output.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        try {
            this.xml = output.createXMLStreamWriter(w);
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public DiffXMLOutput(OutputStream out) {
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        output.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        try {
            this.xml = output.createXMLStreamWriter(out);
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setMode(Operator operator) {
        if (!operator.isEdit()) {
            throw new IllegalArgumentException("operator must edit");
        }
        this.operator = operator;
    }

    private static String toElement(Operator operator) {
        return operator == Operator.INS ? "ins" : "del";
    }

    public final void setWriteXMLDeclaration(boolean show) {
        this.includeXMLDeclaration = show;
    }

    public void write(TrackedSequence<T> sequence) throws DiffException {
        NamespaceSet namespaces = NamespaceSet.noNamespace();
        namespaces.add(DIFF_NS);
        namespaces.add(DEL_NS);
        namespaces.add(INS_NS);
        namespaces.add(sequence.getNamespaces());
        try {
            this.start(namespaces);
            for (TrackedToken trackedToken : sequence) {
                this.write(trackedToken);
            }
        }
        catch (XMLStreamException ex) {
            throw new DiffException((Exception)ex);
        }
    }

    private void start(NamespaceSet namespaces) throws XMLStreamException {
        if (this.includeXMLDeclaration) {
            this.xml.writeStartDocument("utf-8", "1.0");
        }
        for (Namespace namespace : namespaces) {
            String uri = namespace.getUri();
            if (uri.isEmpty()) continue;
            this.xml.setPrefix(namespace.getPrefix(), uri);
        }
    }

    private void write(TrackedToken<T> token) throws XMLStreamException {
        if (token.getType() == XMLTokenType.START_ELEMENT) {
            token.toXML(this.xml);
            if (this.declareNamespace) {
                this.xml.writeNamespace(DIFF_NS.getPrefix(), DIFF_NS.getUri());
                this.xml.writeNamespace(DEL_NS.getPrefix(), DEL_NS.getUri());
                this.xml.writeNamespace(INS_NS.getPrefix(), INS_NS.getUri());
                this.declareNamespace = false;
            }
            if (token.getOrigin() != null) {
                String name = this.operator == Operator.INS ? "insert" : "delete";
                this.xml.writeAttribute(DIFF_NS.getUri(), name, "true");
            }
        } else if (token.getType() == XMLTokenType.TEXT) {
            if (token.getOrigin() != null) {
                this.xml.writeStartElement(DIFF_NS.getUri(), DiffXMLOutput.toElement(this.operator));
                token.toXML(this.xml);
                this.xml.writeEndElement();
            } else {
                token.toXML(this.xml);
            }
        } else if (token.getType() == XMLTokenType.ATTRIBUTE) {
            token.toXML(this.xml);
            if (token.getOrigin() != null && token.getNamespaceURI().isEmpty()) {
                Namespace namespace = this.operator == Operator.INS ? INS_NS : DEL_NS;
                this.xml.writeAttribute(namespace.getUri(), token.getName(), token.getValue());
            }
        } else {
            token.toXML(this.xml);
        }
        this.xml.flush();
    }
}

