/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.cache;

import java.io.InvalidClassException;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SafeCacheWrapper<K extends Serializable, V extends Serializable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeCacheWrapper.class);
    private final Cache cache;

    public SafeCacheWrapper(Cache cache) {
        this.cache = cache;
    }

    public static <K extends Serializable, V extends Serializable> SafeCacheWrapper<K, V> getInstance(String name) {
        return new SafeCacheWrapper<K, V>(CacheManager.getInstance().getCache(name));
    }

    public Cache getCache() {
        return this.cache;
    }

    public void acquireWriteLockOnKey(K key) {
        this.cache.acquireWriteLockOnKey(key);
    }

    public void releaseWriteLockOnKey(K key) {
        this.cache.releaseWriteLockOnKey(key);
    }

    public @Nullable V get(K key) throws IllegalStateException, CacheException {
        Element element = this.getElement(key);
        if (element != null) {
            return (V)((Serializable)element.getObjectValue());
        }
        return null;
    }

    public void put(K key, V value) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.putElement(new Element(key, value));
    }

    public void putElement(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        try {
            this.cache.put(element);
        }
        catch (CacheException ex) {
            if (ex.getCause() instanceof InvalidClassException) {
                this.removeAll(ex.getCause());
                this.cache.put(element);
            }
            throw ex;
        }
    }

    public @Nullable Element getElement(K key) throws IllegalStateException, CacheException {
        try {
            return this.cache.get(key);
        }
        catch (CacheException ex) {
            if (ex.getCause() instanceof InvalidClassException) {
                this.removeAll(ex.getCause());
                return null;
            }
            throw ex;
        }
    }

    public boolean remove(K key) throws IllegalStateException {
        try {
            return this.cache.remove(key);
        }
        catch (CacheException ex) {
            if (ex.getCause() instanceof InvalidClassException) {
                this.removeAll(ex.getCause());
                return true;
            }
            throw ex;
        }
    }

    public void removeAll() {
        this.cache.removeAll();
    }

    private void removeAll(Throwable ex) {
        LOGGER.warn("Cache '{}' cleared due to deserialization error: {}", (Object)this.cache.getName(), (Object)ex.getMessage());
        this.cache.removeAll();
    }
}

