/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.Year;
import java.time.format.DateTimeParseException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class YearStringConverter
implements TypeConverter<Year, String> {
    private static final long serialVersionUID = 1318087260153646890L;

    @Override
    public Year toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Year.parse(str);
        }
        catch (DateTimeParseException pe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, Year.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(Year year) {
        return year != null ? year.toString() : null;
    }
}

