/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.web;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.WebhookQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.webhook.event.EventAction;
import com.pageseeder.webhook.web.WebhookErrorID;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookDetails {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebhookDetails.class);
    private @Nullable Client client = null;
    private @Nullable String name = null;
    private @Nullable String url = null;
    private @Nullable Boolean server = null;
    private @Nullable String projects = null;
    private @Nullable String groups = null;
    private @Nullable String events = null;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Webhook.ObjectType object = null;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Webhook.Format format = null;
    private @Nullable Boolean insecuressl = null;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Webhook.Status status = null;

    public @Nullable Client getClient() {
        return this.client;
    }

    public @Nullable String getURL() {
        return this.url;
    }

    public void populate(Webhook webhook) {
        if (this.client != null) {
            webhook.setClient(this.client);
        }
        if (this.url != null) {
            webhook.setURL(this.url);
        }
        if (this.events != null && this.events.isEmpty()) {
            webhook.setEvents(null);
        } else if (this.events != null) {
            webhook.setEvents(this.events);
        }
        if (this.groups != null && this.groups.isEmpty()) {
            webhook.setGroups(null);
        } else if (this.groups != null) {
            webhook.setGroups(this.groups);
        }
        if (this.projects != null && this.projects.isEmpty()) {
            webhook.setProjects(null);
        } else if (this.projects != null) {
            webhook.setProjects(this.projects);
        }
        if (this.insecuressl != null) {
            webhook.setInsecureSSL(this.insecuressl);
        }
        if (this.name != null) {
            webhook.setName(this.name);
        }
        if (this.format != null) {
            webhook.setFormat(this.format);
        }
        if (this.object != null) {
            webhook.setObject(this.object);
        }
        if (this.server != null) {
            webhook.setServer(this.server);
        }
        if (this.status != null) {
            webhook.setStatus(this.status);
        }
    }

    public static boolean checkClient(GeneratorRequest req, GeneratorResponse res, Webhook webhook) throws QueryFailedException {
        Client client = OAuthQuery.getClient((Database)req.getDatabase(), (String)req.getParameter((Parameter)StandardParameters.client));
        if (!webhook.getClient().equals((Object)client)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Client does not match webhook client");
            return false;
        }
        return true;
    }

    public static @Nullable WebhookDetails loadDetails(GeneratorRequest req, GeneratorResponse res, @Nullable Webhook existing) {
        Group gp;
        Database db = req.getDatabase();
        WebhookDetails details = new WebhookDetails();
        String clientId = req.getParameter((Parameter)StandardParameters.newclient);
        details.name = req.getParameter((Parameter)StandardParameters.name);
        details.url = req.getParameter((Parameter)StandardParameters.url);
        String server = req.getParameter((Parameter)StandardParameters.server);
        details.projects = req.getParameter((Parameter)StandardParameters.projects);
        details.groups = req.getParameter((Parameter)StandardParameters.groups);
        details.events = req.getParameter((Parameter)StandardParameters.events);
        String object = req.getParameter((Parameter)StandardParameters.object);
        String format = req.getParameter((Parameter)StandardParameters.format);
        String insecureSsl = req.getParameter((Parameter)StandardParameters.insecuressl);
        String status = req.getParameter((Parameter)StandardParameters.status);
        if (existing == null) {
            if (object == null) {
                object = "minimal";
            }
            if (format == null) {
                format = "xml";
            }
            details.server = "true".equals(server);
            details.insecuressl = "true".equals(insecureSsl);
            status = null;
        } else {
            details.server = server != null ? Boolean.valueOf(server) : null;
            Boolean bl = details.insecuressl = insecureSsl != null ? Boolean.valueOf(insecureSsl) : null;
        }
        if (clientId != null) {
            try {
                details.client = OAuthQuery.getClient((Database)db, (String)clientId);
                if (details.client == null) {
                    res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)WebhookErrorID.INVALID_CLIENT);
                    return null;
                }
            }
            catch (DatabaseException ex) {
                LOGGER.error("Failed to find OAuth client {}", (Object)clientId, (Object)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to find OAuth client " + clientId + ": " + ex.getMessage());
                return null;
            }
        }
        if (details.name != null && !details.name.isEmpty()) {
            try {
                Webhook w = WebhookQuery.getWebhookByName((Database)db, (String)details.name);
                if (w != null && !w.equals((Object)existing)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)WebhookErrorID.NAME_IN_USE);
                    return null;
                }
            }
            catch (DatabaseException ex) {
                LOGGER.error("Failed to find OAuth client {}", (Object)clientId, (Object)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to find OAuth client " + clientId + ": " + ex.getMessage());
                return null;
            }
        }
        try {
            if (details.url != null) {
                new URL(details.url);
            }
        }
        catch (MalformedURLException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)WebhookErrorID.INVALID_URL);
            return null;
        }
        if (object != null) {
            details.object = Webhook.ObjectType.fromString((String)object);
            if (details.object == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)WebhookErrorID.INVALID_OBJECT);
                return null;
            }
        }
        if (format != null) {
            details.format = Webhook.Format.fromString((String)format);
            if (details.format == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)WebhookErrorID.INVALID_FORMAT);
                return null;
            }
        }
        if (status != null) {
            details.status = Webhook.Status.fromString((String)status);
            if (details.status == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)WebhookErrorID.INVALID_STATUS);
                return null;
            }
        }
        if (details.projects != null && !details.projects.isEmpty()) {
            for (String project : details.projects.split(",")) {
                try {
                    gp = DatabaseQuery.getGroupByName((Database)db, (String)project);
                    if (gp != null && GroupRule.isProject((Group)gp)) continue;
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)WebhookErrorID.INVALID_PROJECT);
                    return null;
                }
                catch (DatabaseException ex) {
                    LOGGER.error("Failed to load project {}", (Object)project, (Object)ex);
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load project " + project + ": " + ex.getMessage());
                    return null;
                }
            }
        }
        if (details.groups != null && !details.groups.isEmpty()) {
            for (String group : details.groups.split(",")) {
                try {
                    gp = DatabaseQuery.getGroupByName((Database)db, (String)group);
                    if (gp != null && !GroupRule.isProject((Group)gp)) continue;
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)WebhookErrorID.INVALID_GROUP);
                    return null;
                }
                catch (DatabaseException ex) {
                    LOGGER.error("Failed to load group {}", (Object)group, (Object)ex);
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load group " + group + ": " + ex.getMessage());
                    return null;
                }
            }
        }
        if (details.events != null && !details.events.isEmpty()) {
            for (String event : details.events.split(",")) {
                EventAction action;
                String[] parts = event.split("\\.");
                if (parts.length == 2 && ("*".equals(parts[1]) || (action = EventAction.fromString(parts[1])) != null && action.supportsObject(parts[0]))) continue;
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)WebhookErrorID.INVALID_EVENT);
                return null;
            }
        }
        return details;
    }

    public boolean eventsUpdated() {
        return this.events != null;
    }

    public boolean statusUpdated() {
        return this.status != null;
    }
}

