/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.event;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.webhook.event.Event;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.eclipse.jdt.annotation.Nullable;

public class EventsCache
implements UniversallyPrintable {
    private final Cache eventsCache;
    private Set<String> eventFilters = ConcurrentHashMap.newKeySet();
    private Long lastProcessedTimestamp = null;

    public EventsCache() {
        this.eventsCache = CacheManager.getInstance().getCache("webhook-events");
    }

    public boolean includeEvent(String type) {
        if (type == null) {
            return false;
        }
        if (this.eventFilters.contains("*.*")) {
            return true;
        }
        for (String supported : this.eventFilters) {
            if (supported.equals(type)) {
                return true;
            }
            if (!supported.endsWith(".*") || !type.startsWith(supported.replaceFirst("\\*$", ""))) continue;
            return true;
        }
        return false;
    }

    public void addFilters(Collection<String> filters) {
        if (filters.isEmpty()) {
            this.eventFilters.add("*.*");
        } else {
            this.eventFilters.addAll(filters);
        }
    }

    public void setLastProcessedTimestamp(long datetime) {
        this.lastProcessedTimestamp = datetime;
    }

    public Long getLastProcessedTimestamp() {
        return this.lastProcessedTimestamp;
    }

    public void setFilters(Collection<String> filters) {
        ConcurrentHashMap.KeySetView<String, Boolean> newfilters = ConcurrentHashMap.newKeySet();
        newfilters.addAll(filters);
        this.eventFilters = newfilters;
    }

    public void add(Event event) {
        this.eventsCache.put(new Element((Serializable)((Object)event.getID()), (Serializable)event));
    }

    public Event get(String id) {
        Element element = this.eventsCache.get((Serializable)((Object)id));
        return element == null ? null : (Event)element.getObjectValue();
    }

    public Collection<Event> getNonQueuedEvents() {
        ArrayList<Event> events = new ArrayList<Event>();
        for (Object key : this.eventsCache.getKeys()) {
            Event event;
            Element cached = this.eventsCache.get(key);
            if (cached == null || cached.isExpired() || (event = (Event)cached.getObjectValue()).isQueued()) continue;
            events.add(event);
        }
        return events;
    }

    public void setEventQueued(String id) {
        Element element = this.eventsCache.get((Serializable)((Object)id));
        if (element != null) {
            Event event = ((Event)element.getObjectValue()).cloneQueued();
            this.eventsCache.put(new Element((Serializable)((Object)event.getID()), (Serializable)event));
        }
    }

    public void removeEventsWithoutID(Collection<String> idsToKeep, @Nullable Long createdBefore) {
        for (Object key : this.eventsCache.getKeys()) {
            Element cached = this.eventsCache.get(key);
            if (cached == null || idsToKeep.contains(((Event)cached.getObjectValue()).getID()) || createdBefore == null || cached.getCreationTime() >= createdBefore) continue;
            this.eventsCache.remove(key);
        }
    }

    public void close() {
        this.eventsCache.dispose();
    }

    public void print(OutputPrinter out) {
        out.startObject("events");
        out.field("count", (long)this.eventsCache.getKeysWithExpiryCheck().size());
        out.startCollection("events", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Object id : this.eventsCache.getKeys()) {
            Element cached = this.eventsCache.get(id);
            if (cached == null) continue;
            ((Event)cached.getObjectValue()).print(out);
        }
        out.endCollection();
        out.endObject();
    }
}

