/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public enum EventAction implements Serializable
{
    created("uri", "comment", "group", "groupfolder", "membership", "member", "project", "publication"),
    modified("uri", "comment", "group", "groupfolder", "groupproperties", "membership", "member", "project", "publication"),
    archived("uri", "comment", "group", "project"),
    deleted("uri", "comment", "group", "groupfolder", "membership", "member", "project", "publication"),
    unarchived("comment"),
    updated("task", "workflow"),
    ping("webhook"),
    started("server");

    private final Collection<String> supportedObjects = new ArrayList<String>();

    public boolean supportsObject(String object) {
        return this.supportedObjects.contains(object);
    }

    private EventAction(String ... supported) {
        this.supportedObjects.addAll(Arrays.asList(supported));
    }

    public static EventAction fromString(String action) {
        if (action == null) {
            return null;
        }
        for (EventAction a : EventAction.values()) {
            if (!action.equals(a.toString())) continue;
            return a;
        }
        return null;
    }
}

