/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageWebhookCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.WebhookQuery;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.webhook.manager.EHCacheLogFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Output(types={OutputType.XML, OutputType.JSON})
public final class ListWebhooks
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageWebhookCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        if (req.getParameter((Parameter)StandardParameters.clear_cache_warning, false)) {
            EHCacheLogFilter.clearEHCacheWarning();
        }
        String statuses = req.getParameter((Parameter)StandardParameters.statuses);
        List webhooks = WebhookQuery.listWebhooksByStatus((Database)req.getDatabase(), statuses == null ? null : Arrays.asList(statuses.split(",")));
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("webhooks");
        out.startCollection("webhooks", OutputPrinter.CollectionOption.JSON_ONLY);
        if (EHCacheLogFilter.hasEHCacheWarning()) {
            ArrayList<String> current = new ArrayList<String>();
            current.add(Webhook.Status.active.name());
            current.add(Webhook.Status.error.name());
            current.add(Webhook.Status.warning.name());
            if (!WebhookQuery.listWebhooksByStatus((Database)req.getDatabase(), current).isEmpty()) {
                out.field("cache-error", "true");
            } else {
                EHCacheLogFilter.clearEHCacheWarning();
            }
        }
        for (Webhook webhook : webhooks) {
            out.writeWebhook(webhook);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

