/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.epub.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Templates;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.pageseeder.epub.Config;
import org.pageseeder.epub.EPubPreProcessor;
import org.pageseeder.epub.ant.Param;
import org.pageseeder.epub.util.Files;
import org.pageseeder.epub.util.XSLT;
import org.pageseeder.epub.util.ZipUtils;

public final class ImportTask
extends Task {
    private File _source;
    private File _destination;
    private File _working;
    private File _config;
    private List<Param> _parameters = new ArrayList<Param>();

    public void setSrc(File epub) {
        if (!epub.exists()) {
            throw new BuildException("the document " + epub.getName() + " doesn't exist");
        }
        if (epub.isDirectory()) {
            throw new BuildException("the document " + epub.getName() + " can't be a directory");
        }
        String name = epub.getName();
        if (!name.endsWith(".epub") && !name.endsWith(".zip")) {
            this.log("An EPUB file should generally end with .epub or .zip - but was " + name);
        }
        this._source = epub;
    }

    public void setDest(File destination) {
        this._destination = destination;
    }

    public void setWorking(File working) {
        if (working.exists() && !working.isDirectory()) {
            throw new BuildException("if working folder exists, it must be a directory");
        }
        this._working = working;
    }

    public void setConfig(File config) {
        if (!config.exists() || config.isDirectory()) {
            throw new BuildException("your configuration file must exist and be a file");
        }
        this._config = config;
    }

    public Param createParam() {
        Param param = new Param();
        this._parameters.add(param);
        return param;
    }

    public void execute() throws BuildException {
        if (this._source == null) {
            throw new BuildException("Source document must be specified using 'src' attribute");
        }
        if (this._working == null) {
            this._working = ImportTask.getDefaultWorkingFolder();
        }
        if (!this._working.exists()) {
            this._working.mkdirs();
        }
        if (this._destination == null) {
            this._destination = this._source.getParentFile();
            this.log("Destination set to source directory " + this._destination.getAbsolutePath() + "");
        }
        if (this._config == null) {
            this._config = null;
            this.log("Using default epub configuration for import");
        }
        File folder = null;
        String name = null;
        if (this._destination.isFile()) {
            folder = this._destination.getParentFile();
            name = this._destination.getName();
            if (name.endsWith(".psml")) {
                name = name.substring(0, name.length() - 5);
            }
        } else {
            folder = this._destination;
            name = this._source.getName();
            if (name.endsWith(".epub")) {
                name = name.substring(0, name.length() - 5);
            }
        }
        Files.ensureDirectoryExists((File)folder);
        this.log("Extracting EPUB: " + this._source.getName());
        File unpacked = new File(this._working, "unpacked");
        unpacked.mkdir();
        ZipUtils.unzip((File)this._source, (File)unpacked);
        File preprocessed = new File(this._working, "preprocessed");
        EPubPreProcessor processor = new EPubPreProcessor(unpacked, preprocessed);
        try {
            processor.process();
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
        this.log("Process with XSLT");
        File container = new File(preprocessed, "META-INF/container.xml");
        Templates templates = XSLT.getTemplatesFromResource((String)"com/pageseeder/ant/epub/xslt/import.xsl");
        String outuri = folder.toURI().toString();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_rootfolder", preprocessed.toURI().toString());
        parameters.put("_outputfolder", outuri);
        parameters.put("_epubfilename", this._source.getName());
        if (this._config != null) {
            parameters.put("_configfileurl", this._config.toURI().toString());
        }
        XSLT.transform((File)container, (File)new File(folder, name + ".psml"), (Templates)templates, parameters);
        ImportTask.copyMedia(preprocessed, folder);
    }

    private static File getDefaultWorkingFolder() {
        String tmp = "psepub-" + System.currentTimeMillis();
        return new File(System.getProperty("java.io.tmpdir"), tmp);
    }

    private static void copyMedia(File from, File to) {
        try {
            File media = new File(from, Config.MEDIA_FOLDER);
            File mediaOut = new File(to, Config.MEDIA_FOLDER);
            Files.ensureDirectoryExists((File)mediaOut);
            for (File m : media.listFiles()) {
                Files.copy((File)m, (File)new File(mediaOut, m.getName()));
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }
}

