/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.ui;

import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.logback.AccessLogger;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.common.http.HttpRedirect;
import com.pageseeder.common.properties.DatabaseSettings;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.URI;
import com.pageseeder.layout.ui.LayoutContextStatus;
import com.pageseeder.layout.ui.SharedRequestContext;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.http.HttpMethod;
import org.pageseeder.berlioz.servlet.BerliozServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UIBerliozServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIBerliozServlet.class);
    static final String CONTEXT_ATTRIBUTE = "com.pageseeder.layout.ui.SharedRequestContext";
    static final String SERVLET_CONTEXT_ATTRIBUTE = "com.pageseeder.layout.ui.ServletContext";
    private static final String LICENSE_PATH = GlobalSettings.getSitePrefix() + "/ui/admin/license.html";
    private static final String SIGNIN_PATH = GlobalSettings.getSitePrefix() + "/ui/signin.html";
    private static final String SETUP_PATH = GlobalSettings.getSitePrefix() + "/ui/setup.html";
    private final BerliozServlet berlioz = new BerliozServlet();

    public void init(ServletConfig servletConfig) throws ServletException {
        this.berlioz.init(servletConfig);
    }

    public void destroy() {
        this.berlioz.destroy();
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            HttpMethod method = HttpMethod.valueOf((String)req.getMethod());
            if (method == HttpMethod.OPTIONS) {
                this.doOptions(req, res);
            } else {
                this.handleUIService(req, res);
            }
        }
        catch (IllegalArgumentException ex) {
            this.berlioz.service((ServletRequest)req, (ServletResponse)res);
        }
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleUIService(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleUIService(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleUIService(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleUIService(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleUIService(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) {
        this.berlioz.doOptions(req, res);
    }

    private void handleUIService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Database db;
        req.setAttribute(SERVLET_CONTEXT_ATTRIBUTE, (Object)req.getServletContext());
        if (UIBerliozServlet.isSetupOrDBError(req)) {
            this.berlioz.service((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if ("dev".equals(GlobalSettings.getString((String)"productKey", (String)"")) && !req.getServletPath().startsWith("/ui/error.")) {
            if (UIBerliozServlet.isLocalhost(req.getServerName())) {
                res.sendError(402, "The developer license can only be used on localhost or *.localhost domains.");
                return;
            }
            if (UIBerliozServlet.isLocalhost(GlobalSettings.get((String)"webSiteAddress"))) {
                res.sendError(402, "The developer license must have webSiteAddress=localhost or [x.]localhost in global.properties.");
                return;
            }
        }
        HttpSession session = req.getSession(false);
        if (req.isRequestedSessionIdFromURL() && req.isRequestedSessionIdValid() && session != null) {
            Cookie sc = new Cookie("JSESSIONID", session.getId());
            sc.setHttpOnly(true);
            sc.setSecure(true);
            sc.setPath("/");
            sc.setMaxAge(-1);
            res.addCookie(sc);
        }
        long start = System.currentTimeMillis();
        SharedRequestContext context = null;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            if ("Initializing PageSeeder".equals(ex.getMessage())) {
                res.sendError(503, ex.getMessage());
                return;
            }
            if (Strings.isEmpty((String)DatabaseSettings.get((String)"DBURL"))) {
                HttpRedirect.sendRedirect((HttpServletRequest)req, (HttpServletResponse)res, (String)SETUP_PATH);
                return;
            }
            res.sendError(502, "Unable to open database connection: " + ex.getMessage());
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            context = new SharedRequestContext(db, tr);
            LayoutContextStatus status = context.load(req, res);
            if (status.isOK() || status == LayoutContextStatus.PAYMENT_REQUIRED && LICENSE_PATH.equals(req.getRequestURI()) || status == LayoutContextStatus.UNAUTHORIZED && SIGNIN_PATH.equals(req.getRequestURI())) {
                req.setAttribute(CONTEXT_ATTRIBUTE, (Object)context);
                if (!CSRF.validateAntiCSRFToken((HttpServletRequest)req)) {
                    res.sendError(419, "Missing correct CSRF token");
                } else {
                    this.berlioz.service((ServletRequest)req, (ServletResponse)res);
                }
            } else if (status == LayoutContextStatus.REDIRECT) {
                String path = (String)req.getAttribute("com.pageseeder.layout.ui.REDIRECT_PATH");
                HttpRedirect.sendRedirect((HttpServletRequest)req, (HttpServletResponse)res, (String)path);
            } else if (status == LayoutContextStatus.UNAUTHORIZED) {
                if (req.getRequestURI().endsWith(".json") || req.getRequestURI().endsWith(".xml")) {
                    res.sendError(401, status.getMessage());
                } else {
                    String location = GlobalSettings.getSitePrefix() + "/ui/signin.html?location=" + URLEncoder.encode(req.getRequestURI() + (String)(req.getQueryString() != null ? "?" + req.getQueryString() : ""), StandardCharsets.UTF_8);
                    HttpRedirect.sendRedirect((HttpServletRequest)req, (HttpServletResponse)res, (String)location);
                }
            } else {
                res.sendError(status.getHttpCode(), status.getMessage());
            }
            UIBerliozServlet.log(req, res.getStatus(), context, start);
            tr.commit(context.getServiceId());
        }
        catch (StartTransactionException ex) {
            UIBerliozServlet.log(req, 502, context, start);
            LOGGER.error("Unexpected transaction error", (Throwable)ex);
            res.sendError(502, ex.getMessage());
        }
        catch (DatabaseException ex) {
            UIBerliozServlet.log(req, 502, context, start);
            tr.abort();
            LOGGER.error("Unexpected database error", (Throwable)ex);
            res.sendError(502, ex.getMessage());
        }
        catch (Exception ex) {
            UIBerliozServlet.log(req, 500, context, start);
            tr.abort();
            throw new ServletException("An unexpected error occurred: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            db.close();
        }
    }

    private static void log(HttpServletRequest req, int status, @Nullable SharedRequestContext context, long start) {
        String serviceId;
        String username = SecurityUtils.getUsername((HttpServletRequest)req);
        String string = serviceId = context != null ? context.getServiceId() : "unknown";
        if ("signout".equals(serviceId) || "signin".equals(serviceId) && username == null) {
            return;
        }
        AccessEvent access = AccessEvent.newInstance((HttpServletRequest)req, (String)username);
        String componentType = "ui";
        access.setComponent(componentType, serviceId);
        if (context != null) {
            access.setGroup(context.getGroup());
            URI uri = context.getURI();
            if (uri != null) {
                access.setDocDetails(uri);
            }
        }
        access.setTime(Long.valueOf(System.currentTimeMillis() - start));
        access.setStatus(status);
        access.setPermission(context != null ? PermissionManager.getAccessPermission((PermissionCheck)context.getPermissionCheck()) : AccessEvent.Permission.PUBLIC);
        AccessLogger.track((AccessEvent)access);
    }

    private static boolean isLocalhost(String host) {
        return !"localhost".equals(host) && !host.endsWith(".localhost");
    }

    private static boolean isSetupOrDBError(HttpServletRequest req) {
        if (req.getServletPath().startsWith("/ui/setup.")) {
            return true;
        }
        if (req.getServletPath().startsWith("/ui/error.")) {
            Integer status = (Integer)req.getAttribute("javax.servlet.error.status_code");
            return status != null && (status == 502 || status == 503);
        }
        return false;
    }
}

