/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.ixml;

import java.util.ArrayList;
import java.util.List;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.ixml.IndexDocumentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

final class IndexDocumentHandler_5_0
extends DefaultHandler
implements IndexDocumentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexDocumentHandler_5_0.class);
    private final String _catalog;
    private List<FlintDocument> documents;
    private FlintDocument _document;
    private boolean _isField;
    private FlintField field = null;
    private final StringBuilder _value = new StringBuilder();

    public IndexDocumentHandler_5_0(String catalog) {
        this._catalog = catalog;
    }

    @Override
    public List<FlintDocument> getDocuments() {
        return this.documents;
    }

    @Override
    public void startDocument() {
        this.documents = new ArrayList<FlintDocument>();
        this.field = new FlintField(this._catalog);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("field".equals(qName)) {
            this.startFieldElement(attributes);
        } else if ("document".equals(qName)) {
            this.startDocumentElement();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("field".equals(qName)) {
            this.endFieldElement();
        } else if ("document".equals(qName)) {
            this.endDocumentElement();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this._isField) {
            this._value.append(ch, start, length);
        }
    }

    private void startDocumentElement() {
        this._document = new FlintDocument();
    }

    private void endDocumentElement() {
        if (this._document.isEmpty()) {
            LOGGER.warn("This document is empty - will not be stored");
        } else {
            this.documents.add(this._document);
        }
        this._document = null;
    }

    private void startFieldElement(Attributes atts) {
        String store = atts.getValue("store");
        this.field.name(atts.getValue("name")).index(atts.getValue("index")).store("compress".equals(store) ? "true" : store);
        String numType = atts.getValue("numeric-type");
        if (numType != null) {
            this.field.numeric(numType).precisionStep(atts.getValue("precision-step"));
        }
        this.field.termVector(atts.getValue("term-vector")).termVectorPositions(atts.getValue("term-vector-positions")).termVectorOffsets(atts.getValue("term-vector-offsets")).termVectorPayloads(atts.getValue("term-vector-payloads")).tokenize(atts.getValue("tokenize")).docValues(atts.getValue("doc-values"), numType != null);
        if (atts.getValue("boost") != null) {
            LOGGER.warn("boost attribute is deprecated, boost should be used at query time, not");
        }
        this.field.dateFormat(atts.getValue("date-format")).resolution(atts.getValue("date-resolution"));
        this._isField = true;
    }

    private void endFieldElement() {
        try {
            this.field.value(this._value.toString());
            this._document.add(this.field);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            LOGGER.warn("Unable to create field: " + this.field.name(), (Throwable)ex);
        }
        this.field = new FlintField(this._catalog);
        this._isField = false;
        this._value.setLength(0);
    }
}

