/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.content;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentTranslator;

public final class SourceForwarder
implements ContentTranslator {
    private final List<String> _mediaTypes;
    private final Charset _charset;

    public SourceForwarder(String mediaType, String charset) throws IllegalArgumentException {
        this(mediaType, Charset.forName(charset));
    }

    public SourceForwarder(List<String> mediaTypes, String charset) throws IllegalArgumentException {
        this(mediaTypes, Charset.forName(charset));
    }

    public SourceForwarder(String mediaType, Charset charset) throws IllegalArgumentException {
        if (mediaType == null) {
            throw new IllegalArgumentException("mediaType is null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset is null");
        }
        this._mediaTypes = Collections.singletonList(mediaType);
        this._charset = charset;
    }

    public SourceForwarder(List<String> mediaTypes, Charset charset) throws IllegalArgumentException {
        if (mediaTypes == null) {
            throw new IllegalArgumentException("mediaTypes is null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset is null");
        }
        this._mediaTypes = mediaTypes;
        this._charset = charset;
    }

    @Override
    public Reader translate(Content content) throws IndexException {
        if (content.isDeleted()) {
            return null;
        }
        if (!this._mediaTypes.contains(content.getMediaType())) {
            return null;
        }
        InputStream in = content.getSource();
        if (in != null) {
            return new InputStreamReader(in, this._charset);
        }
        File f = content.getFile();
        try {
            return new FileReader(f);
        }
        catch (FileNotFoundException ex) {
            throw new IndexException("Invalid source file " + f.getAbsolutePath(), ex);
        }
    }
}

