/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.xmlwriter.esc;

import java.io.IOException;
import java.io.Writer;
import org.pageseeder.xmlwriter.esc.XMLEscapeWriter;
import org.pageseeder.xmlwriter.esc.XMLEscapeWriterBase;

public final class XMLEscapeWriterUTF8
extends XMLEscapeWriterBase
implements XMLEscapeWriter {
    private static final String UTF8 = "utf-8";

    public XMLEscapeWriterUTF8(Writer writer) throws NullPointerException {
        super(writer, UTF8);
    }

    @Override
    public void writeAttValue(char[] ch, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            char c = ch[i];
            if (c == '<') {
                this.w.write("&lt;");
                continue;
            }
            if (c == '&') {
                this.w.write("&amp;");
                continue;
            }
            if (c == '\"') {
                this.w.write("&quot;");
                continue;
            }
            if (c == '\'') {
                this.w.write("&#39;");
                continue;
            }
            if (c == '\n' || c == '\r' || c == '\t') {
                this.w.write(c);
                continue;
            }
            if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
                XMLEscapeWriterUTF8.doNothing();
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                int codePoint = Character.codePointAt(ch, i, len);
                i += Character.charCount(codePoint) - 1;
                this.w.write("&#x");
                this.w.write(Integer.toHexString(codePoint));
                this.w.write(";");
                continue;
            }
            this.w.write(c);
        }
    }

    @Override
    public void writeText(char[] ch, int off, int len) throws IOException {
        int c = 32;
        for (int i = off; i < off + len; ++i) {
            c = ch[i];
            if (c == 60) {
                this.w.write("&lt;");
                continue;
            }
            if (c == 62) {
                this.w.write("&gt;");
                continue;
            }
            if (c == 38) {
                this.w.write("&amp;");
                continue;
            }
            if (c == 10 || c == 13 || c == 9) {
                this.w.write(c);
                continue;
            }
            if (c < 32 || c >= 127 && c < 160) {
                XMLEscapeWriterUTF8.doNothing();
                continue;
            }
            if (c >= 55296 && c <= 57343) {
                int codePoint = Character.codePointAt(ch, i, len);
                i += Character.charCount(codePoint) - 1;
                this.w.write("&#x");
                this.w.write(Integer.toHexString(codePoint));
                this.w.write(";");
                continue;
            }
            this.w.write(c);
        }
    }

    @Override
    public void writeText(char c) throws IOException {
        if (c == '<') {
            this.w.write("&lt;");
        } else if (c == '>') {
            this.w.write("&gt;");
        } else if (c == '&') {
            this.w.write("&amp;");
        } else if (c == '\n' || c == '\r' || c == '\t') {
            this.w.write(c);
        } else if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
            XMLEscapeWriterUTF8.doNothing();
        } else {
            this.w.write(c);
        }
    }

    private static void doNothing() {
    }
}

