/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.xmlwriter.esc;

import org.pageseeder.xmlwriter.esc.XMLEscape;
import org.pageseeder.xmlwriter.esc.XMLEscapeBase;

public final class XMLEscapeUTF8
extends XMLEscapeBase
implements XMLEscape {
    public static final XMLEscape UTF8_ESCAPE = new XMLEscapeUTF8();
    private static final String ENCODING = "utf-8";

    private XMLEscapeUTF8() {
        super(ENCODING);
    }

    @Override
    public String toAttributeValue(char[] ch, int off, int len) {
        StringBuilder out = new StringBuilder();
        for (int i = off; i < off + len; ++i) {
            char c = ch[i];
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            if (c == '\"') {
                out.append("&quot;");
                continue;
            }
            if (c == '\'') {
                out.append("&#39;");
                continue;
            }
            if (c == '\n' || c == '\r' || c == '\t') {
                out.append(c);
                continue;
            }
            if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
                XMLEscapeUTF8.doNothing();
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                int codePoint = Character.codePointAt(ch, i, len);
                i += Character.charCount(codePoint) - 1;
                out.append("&#x").append(Integer.toHexString(codePoint)).append(";");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    @Override
    public String toElementText(char[] ch, int off, int len) {
        StringBuffer out = new StringBuffer(len + len / 10);
        for (int i = off; i < off + len; ++i) {
            char c = ch[i];
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            if (c == '\n' || c == '\r' || c == '\t') {
                out.append(c);
                continue;
            }
            if (c < ' ' || c >= '\u007f' && c < '\u00a0') {
                XMLEscapeUTF8.doNothing();
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                int codePoint = Character.codePointAt(ch, i, len);
                i += Character.charCount(codePoint) - 1;
                out.append("&#x").append(Integer.toHexString(codePoint)).append(";");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private static void doNothing() {
    }
}

