/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.docx.ant;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Templates;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.pageseeder.docx.ant.AntLogger;
import org.pageseeder.docx.ant.ExportTask;
import org.pageseeder.docx.ant.Parameter;
import org.pageseeder.docx.util.Files;
import org.pageseeder.docx.util.XSLT;
import org.pageseeder.docx.util.ZipUtils;
import org.slf4j.Logger;

public final class ImportTask
extends Task {
    private File source;
    private File destination;
    private File working;
    private File config;
    private List<Parameter> params = new ArrayList<Parameter>();
    private String mediaFolder;
    private String componentFolder;

    public void setSrc(File docx) {
        if (!docx.exists()) {
            throw new BuildException("the document " + docx.getName() + " doesn't exist");
        }
        if (docx.isDirectory()) {
            throw new BuildException("the document " + docx.getName() + " can't be a directory");
        }
        String name = docx.getName();
        if (!name.endsWith(".docx") && !name.endsWith(".zip")) {
            this.log("Word document file should generally end with .docx or .zip - but was " + name);
        }
        this.source = docx;
    }

    public void setDest(File destination) {
        this.destination = destination;
    }

    public void setWorking(File working) {
        if (working.exists() && !working.isDirectory()) {
            throw new BuildException("if working folder exists, it must be a directory");
        }
        this.working = working;
    }

    public void setConfig(File config) {
        if (!config.exists() || config.isDirectory()) {
            throw new BuildException("your configuration file must exist and be a file");
        }
        this.config = config;
    }

    public void setMediaFolder(String name) {
        this.mediaFolder = name;
    }

    public void setComponentFolder(String name) {
        this.componentFolder = name;
    }

    public Parameter createParam() {
        Parameter param = new Parameter();
        this.params.add(param);
        return param;
    }

    public void execute() throws BuildException {
        File footnotes;
        String componentFolderName;
        String filename;
        File folder;
        String sourcename;
        if (this.source == null) {
            throw new BuildException("Source document must be specified using 'src' attribute");
        }
        if (this.working == null) {
            this.working = ImportTask.getDefaultWorkingFolder();
        }
        if (!this.working.exists()) {
            this.working.mkdirs();
        }
        if (this.destination == null) {
            this.destination = this.source.getParentFile();
            this.log("Destination set to source directory " + this.destination.getAbsolutePath());
        }
        for (Parameter p : this.params) {
            if (p.getName() == null) {
                throw new BuildException("parameters must have a name");
            }
            if (!p.getName().startsWith("_")) continue;
            throw new BuildException("parameter names must not start with an underscore");
        }
        if (this.config == null) {
            this.config = null;
            this.log("Using default wpml configuration for import");
        }
        if ((sourcename = this.source.getName()).toLowerCase().endsWith(".docx")) {
            sourcename = sourcename.substring(0, sourcename.length() - 5);
        }
        if (this.destination.getName().endsWith(".psml")) {
            folder = this.destination.getParentFile();
            filename = this.destination.getName().substring(0, this.destination.getName().length() - 5);
        } else {
            folder = this.destination;
            filename = sourcename.replaceAll(" ", "_").toLowerCase();
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.log("Extracting DOCX: " + this.source.getName());
        File unpacked = new File(this.working, "unpacked");
        unpacked.mkdir();
        ZipUtils.unzip((File)this.source, (File)unpacked);
        this.log("Checking docx");
        File contentTypes = new File(unpacked, "[Content_Types].xml");
        File relationships = new File(unpacked, "_rels/.rels");
        if (!contentTypes.exists()) {
            throw new BuildException("Not a valid DOCX: unable to find [Content_Types].xml");
        }
        if (!relationships.exists()) {
            throw new BuildException("Not a valid DOCX: unable to find _rels/.rels");
        }
        String string = componentFolderName = this.componentFolder == null ? "components" : this.componentFolder;
        String mediaFolderName = this.mediaFolder == null ? "images" : ("".equals(this.mediaFolder) ? filename + "_files" : this.mediaFolder);
        Templates templates = XSLT.getTemplatesFromResource((String)"org/pageseeder/docx/xslt/import.xsl");
        String outuri = folder.toURI().toString();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_rootfolder", unpacked.toURI().toString());
        parameters.put("_outputfolder", outuri);
        parameters.put("_docxfilename", sourcename);
        parameters.put("_mediafoldername", mediaFolderName);
        parameters.put("_componentfoldername", componentFolderName);
        if (this.config != null) {
            parameters.put("_configfileurl", this.config.toURI().toString());
        }
        for (Parameter p : this.params) {
            parameters.put(p.getName(), p.getValue());
        }
        this.log("Unnest");
        Templates unnest = XSLT.getTemplatesFromResource((String)"org/pageseeder/docx/xslt/import-unnest.xsl");
        File document = new File(unpacked, "word/document.xml");
        File newDocument = new File(unpacked, "word/new-document.xml");
        Logger logger = AntLogger.newInstance(this);
        XSLT.transform((File)document, (File)newDocument, (Templates)unnest, parameters, (Logger)logger);
        File endnotes = new File(unpacked, "word/endnotes.xml");
        if (endnotes.canRead()) {
            XSLT.transform((File)endnotes, (File)new File(unpacked, "word/new-endnotes.xml"), (Templates)unnest, parameters, (Logger)logger);
        }
        if ((footnotes = new File(unpacked, "word/footnotes.xml")).canRead()) {
            XSLT.transform((File)footnotes, (File)new File(unpacked, "word/new-footnotes.xml"), (Templates)unnest, parameters, (Logger)logger);
        }
        this.log("Copy media");
        ImportTask.copyMedia(unpacked, folder, mediaFolderName);
        this.log("Process with XSLT (this may take several minutes)");
        XSLT.transform((File)contentTypes, (File)new File(folder, filename + ".psml"), (Templates)templates, parameters, (Logger)logger);
    }

    private static File getDefaultWorkingFolder() {
        String tmp = "psdocx-" + System.currentTimeMillis();
        return new File(System.getProperty("java.io.tmpdir"), tmp);
    }

    private static void copyMedia(File from, File to, String folder) {
        File media = new File(from, "word/media");
        if (!media.exists()) {
            return;
        }
        File mediaOut = new File(to, folder);
        try {
            Files.ensureDirectoryExists((File)mediaOut);
            for (File m : media.listFiles()) {
                if (m.getName().startsWith(ExportTask.MEDIA_PREFIX)) continue;
                Files.copy((File)m, (File)new File(mediaOut, URLDecoder.decode(m.getName().replace("%25", "."), "UTF-8").toLowerCase()));
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }
}

