/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import java.io.File;
import java.io.IOException;

@Requires(database=true, member=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListMemberConfigs
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        Member member = req.getMember();
        if (!GroupRule.isProject((Group)group)) {
            return new ForbiddenCheck();
        }
        return new ViewMemberCheck(member, (PermissionCheck)new ViewGroupCheck(group));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        Member member = req.getMember();
        File root = new File(Settings.getContextPath(), "WEB-INF/config/template/" + group.getName().replace('-', '/') + "/member/" + member.getId());
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("member-configs");
        out.field("project", group.getName());
        out.field("user", member.getId().longValue());
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!ListMemberConfigs.isConfigFileName(file.getName())) continue;
                out.writeFile(file, 0, false);
            }
        }
        out.endObject();
    }

    private static boolean isConfigFileName(String filename) {
        return filename != null && (filename.equals("word-export-config.xml") || filename.equals("word-export-template.docx") || filename.equals("pdf-export-config.xml") || filename.equals("word-import-config.xml") || filename.equals("psml-split-config.xml"));
    }
}

