/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.docx.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.pageseeder.docx.DOCXException;

public class Files {
    private Files() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to) throws IOException {
        Files.ensureDirectoryExists(to.getParentFile());
        if (!to.exists()) {
            to.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(from).getChannel();
            destination = new FileOutputStream(to).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void ensureDirectoryExists(File directory) throws DOCXException {
        boolean done;
        if (!directory.exists() && !(done = directory.mkdirs())) {
            throw new DOCXException("Unable to create target directory for preprocessor");
        }
    }

    public static void renameFiles(File dir, String prefix) {
        File[] children;
        if (dir.exists() && dir.isDirectory() && (children = dir.listFiles()) != null) {
            for (File child : children) {
                child.renameTo(new File(dir, prefix + child.getName()));
            }
        }
    }

    public static void copyDirectory(File source, File target) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        if (source.isDirectory()) {
            String[] children;
            if (!target.exists()) {
                target.mkdir();
            }
            if ((children = source.list()) != null) {
                for (String aChildren : children) {
                    int dot = aChildren.lastIndexOf(46);
                    String base = dot == -1 ? aChildren : aChildren.substring(0, dot);
                    String extension = dot == -1 ? "" : aChildren.substring(dot);
                    String newfilename = base.replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~").replace(".", "%25") + extension;
                    Files.copyDirectory(new File(source, aChildren), new File(target, newfilename));
                }
            }
        } else {
            Files.copy(source, target);
        }
    }
}

