/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.docx;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import org.pageseeder.docx.DOCXException;
import org.pageseeder.docx.DOCXProcessor;
import org.pageseeder.docx.util.Files;
import org.pageseeder.docx.util.XSLT;
import org.pageseeder.docx.util.ZipUtils;

public final class PSMLProcessor {
    private final Builder _builder;
    private final Writer _log;

    private PSMLProcessor(Builder producer) {
        this(producer, new StringWriter());
    }

    private PSMLProcessor(Builder producer, Writer log) {
        if (producer.source() == null) {
            throw new NullPointerException("source is null");
        }
        if (producer.destination() == null) {
            throw new NullPointerException("destination is null");
        }
        this._builder = producer;
        this._log = log;
    }

    public String getLog() {
        if (this._log != null) {
            try {
                this._log.flush();
                this._log.close();
            }
            catch (IOException e) {
                return "";
            }
            return this._log.toString();
        }
        return "";
    }

    public void process() throws IOException {
        File footnotes;
        String componentFolderName;
        String filename;
        File folder;
        String sourcename;
        if (this._builder.destination() == null) {
            this._builder.destination = this._builder.source.getParentFile();
            this.log("Destination set to source directory " + this._builder.destination.getAbsolutePath());
        }
        if ((sourcename = this._builder.source().getName()).toLowerCase().endsWith(".docx")) {
            sourcename = sourcename.substring(0, sourcename.length() - 5);
        }
        if (this._builder.destination().getName().endsWith(".psml")) {
            folder = this._builder.destination().getParentFile();
            filename = this._builder.destination().getName().substring(0, this._builder.destination().getName().length() - 5);
        } else {
            folder = this._builder.destination();
            filename = sourcename.replaceAll(" ", "_").toLowerCase();
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.log("Extracting DOCX: " + this._builder.source().getName());
        File unpacked = new File(this._builder.working(), "unpacked");
        unpacked.mkdir();
        ZipUtils.unzip(this._builder.source(), unpacked);
        this.log("Checking docx");
        File contentTypes = new File(unpacked, "[Content_Types].xml");
        File relationships = new File(unpacked, "_rels/.rels");
        if (!contentTypes.exists()) {
            throw new DOCXException("Not a valid DOCX: unable to find [Content_Types].xml");
        }
        if (!relationships.exists()) {
            throw new DOCXException("Not a valid DOCX: unable to find _rels/.rels");
        }
        Templates templates = XSLT.getTemplatesFromResource("org/pageseeder/docx/xslt/import.xsl");
        String outuri = folder.toURI().toString();
        String string = componentFolderName = this._builder.component() == null ? "components" : this._builder.component();
        String mediaFolderName = this._builder.media() == null ? "images" : ("".equals(this._builder.media()) ? filename + "_files" : this._builder.media());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_rootfolder", unpacked.toURI().toString());
        parameters.put("_outputfolder", outuri);
        parameters.put("_docxfilename", sourcename);
        parameters.put("_mediafoldername", mediaFolderName);
        parameters.put("_componentfoldername", componentFolderName);
        if (this._builder.config() != null) {
            parameters.put("_configfileurl", this._builder.config().toURI().toString());
        }
        parameters.putAll(this._builder.params());
        this.log("Unnest");
        Templates unnest = XSLT.getTemplatesFromResource("org/pageseeder/docx/xslt/import-unnest.xsl");
        File document = new File(unpacked, "word/document.xml");
        File newDocument = new File(unpacked, "word/new-document.xml");
        XSLT.transform(document, newDocument, unnest, parameters, null);
        File endnotes = new File(unpacked, "word/endnotes.xml");
        if (endnotes.canRead()) {
            XSLT.transform(endnotes, new File(unpacked, "word/new-endnotes.xml"), unnest, parameters, null);
        }
        if ((footnotes = new File(unpacked, "word/footnotes.xml")).canRead()) {
            XSLT.transform(footnotes, new File(unpacked, "word/new-footnotes.xml"), unnest, parameters, null);
        }
        this.log("Copy media");
        PSMLProcessor.copyMedia(unpacked, folder, mediaFolderName);
        this.log("Process with XSLT (this may take several minutes)");
        XSLT.transform(contentTypes, new File(folder, filename + ".psml"), templates, parameters, null);
    }

    private void log(String log) throws IOException {
        this._log.append(log).append("\n");
    }

    private static void copyMedia(File from, File to, String folder) {
        File media = new File(from, "word/media");
        if (!media.exists()) {
            return;
        }
        File mediaOut = new File(to, folder);
        try {
            Files.ensureDirectoryExists(mediaOut);
            File[] files = media.listFiles();
            if (files != null) {
                for (File m : files) {
                    if (m.getName().startsWith(DOCXProcessor.MEDIA_PREFIX)) continue;
                    Files.copy(m, new File(mediaOut, URLDecoder.decode(m.getName().replace("%25", "."), "UTF-8").toLowerCase()));
                }
            }
        }
        catch (IOException ex) {
            throw new DOCXException(ex);
        }
    }

    public static class Builder {
        private File source;
        private File destination;
        private File working;
        private File config;
        private String media;
        private String component;
        private Map<String, String> params;
        private Writer log;

        private File source() {
            return this.source;
        }

        private File destination() {
            if (this.destination == null) {
                this.destination = new File(this.source.getParentFile(), "output.psml");
            }
            return this.destination;
        }

        private File working() {
            if (this.working == null) {
                String tmp = "docx-" + System.currentTimeMillis();
                this.working = new File(System.getProperty("java.io.tmpdir"), tmp);
            }
            if (!this.working.exists()) {
                this.working.mkdirs();
            }
            return this.working;
        }

        private File config() {
            if (this.config != null && this.config.exists()) {
                return this.config;
            }
            return null;
        }

        private String media() {
            return this.media;
        }

        private String component() {
            return this.component;
        }

        private Map<String, String> params() {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            return this.params;
        }

        public Builder log(Writer log) {
            this.log = log;
            return this;
        }

        public Builder source(File source) {
            this.source = source;
            return this;
        }

        public Builder destination(File destination) {
            this.destination = destination;
            return this;
        }

        public Builder working(File working) {
            this.working = working;
            return this;
        }

        public Builder config(File config) {
            this.config = config;
            return this;
        }

        public Builder media(String media) {
            this.media = media;
            return this;
        }

        public Builder component(String component) {
            this.component = component;
            return this;
        }

        public Builder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public PSMLProcessor build() {
            if (this.log != null) {
                return new PSMLProcessor(this, this.log);
            }
            return new PSMLProcessor(this);
        }
    }
}

