/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.xslt;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.pageseeder.berlioz.util.CollectedError;
import org.pageseeder.berlioz.util.ErrorCollector;
import org.slf4j.Logger;

public final class XSLTErrorCollector
extends ErrorCollector<TransformerException>
implements ErrorListener {
    private final Logger _logger;

    public XSLTErrorCollector(Logger logger) {
        this._logger = logger;
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        this._logger.error(exception.getMessageAndLocation());
        this.collect(CollectedError.Level.FATAL, exception);
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        this._logger.error(exception.getMessageAndLocation());
        this.collect(CollectedError.Level.ERROR, exception);
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        this._logger.warn(exception.getMessageAndLocation());
        this.collect(CollectedError.Level.WARNING, exception);
    }
}

