/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.xml.BerliozEntityResolver;
import org.pageseeder.berlioz.xml.BerliozErrorHandler;
import org.pageseeder.berlioz.xml.Xml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XMLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLUtils.class);

    private XMLUtils() {
    }

    public static void parse(ContentHandler handler, File xml) throws BerliozException {
        XMLUtils.parse(handler, xml, true);
    }

    public static void parse(ContentHandler handler, Reader reader, boolean validate) throws BerliozException {
        SAXParser parser = XMLUtils.getParser(validate);
        try {
            XMLReader xmlreader = parser.getXMLReader();
            xmlreader.setContentHandler(handler);
            xmlreader.setEntityResolver(BerliozEntityResolver.getInstance());
            xmlreader.setErrorHandler(BerliozErrorHandler.getInstance());
            xmlreader.parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            throw new BerliozException("Could not parse file. " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new BerliozException("Could not read file.", ex);
        }
    }

    public static void parse(ContentHandler handler, File xml, boolean validate) throws BerliozException {
        SAXParser parser = XMLUtils.getParser(validate);
        try {
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setContentHandler(handler);
            reader.setEntityResolver(BerliozEntityResolver.getInstance());
            reader.setErrorHandler(BerliozErrorHandler.getInstance());
            if (xml.isDirectory()) {
                throw new BerliozException("Cannot parse a directory");
            }
            LOGGER.info("Parsing file {}", (Object)xml.toURI());
            reader.parse(new InputSource(xml.toURI().toString()));
        }
        catch (SAXException ex) {
            throw new BerliozException("Could not parse file. " + ex.getMessage(), ex);
        }
        catch (FileNotFoundException ex) {
            LOGGER.warn("Attempted to parse file which cannot be found", (Throwable)ex);
            throw new BerliozException("Could not find file.", ex);
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to parse file", (Throwable)ex);
            throw new BerliozException("Could not read file.", ex);
        }
    }

    public static SAXParser getParser(boolean validating) throws BerliozException {
        SAXParser parser;
        try {
            parser = Xml.newSafeParser(validating);
        }
        catch (ParserConfigurationException ex) {
            throw new BerliozException("Could not configure SAX parser.", ex);
        }
        catch (SAXException ex) {
            throw new BerliozException("Could not setup SAX parser factory: " + ex.getMessage(), ex);
        }
        return parser;
    }
}

