/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.xml;

import org.pageseeder.berlioz.util.CollectedError;
import org.pageseeder.berlioz.util.ErrorCollector;
import org.slf4j.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class SAXErrorCollector
extends ErrorCollector<SAXParseException>
implements ErrorHandler {
    private final Logger _logger;

    public SAXErrorCollector(Logger logger) {
        this._logger = logger;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXParseException {
        this._logger.error("{} (line: {})", (Object)exception.getMessage(), (Object)exception.getLineNumber());
        this.collect(CollectedError.Level.FATAL, exception);
    }

    @Override
    public void error(SAXParseException exception) throws SAXParseException {
        this._logger.error("{} (line: {})", (Object)exception.getMessage(), (Object)exception.getLineNumber());
        this.collect(CollectedError.Level.ERROR, exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXParseException {
        this._logger.warn("{} (line: {})", (Object)exception.getMessage(), (Object)exception.getLineNumber());
        this.collect(CollectedError.Level.WARNING, exception);
    }
}

