/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public enum ISO8601 {
    YEAR("yyyy"),
    CALENDAR_DATE("yyyy-MM-dd"),
    WEEK_DATE("yyyy-'W'WW-d"),
    TIME("HH:mm:ss"),
    DATETIME("yyyy-MM-dd'T'HH:mm:ssZ");

    private final String _format;

    private ISO8601(String format) {
        this._format = format;
    }

    public String format(long date) {
        SimpleDateFormat iso = new SimpleDateFormat(this._format);
        if (this._format.charAt(this._format.length() - 1) == 'Z') {
            String formatted = iso.format(date);
            return formatted.substring(0, formatted.length() - 2) + ":" + formatted.substring(formatted.length() - 2);
        }
        return iso.format(date);
    }

    public Date parse(String date) throws ParseException {
        SimpleDateFormat iso = new SimpleDateFormat(this._format);
        boolean hasTimeZone = this._format.charAt(this._format.length() - 1) == 'Z';
        String parsable = date;
        if (hasTimeZone && date.length() > 2) {
            parsable = date.substring(0, date.length() - 3) + date.substring(date.length() - 2);
        }
        return iso.parse(parsable);
    }

    public static String format(long date, ISO8601 format) {
        return format.format(date);
    }

    public static Date parseAuto(String date) throws ParseException {
        if (date.length() == 4 && date.matches("\\d{4}")) {
            return YEAR.parse(date);
        }
        if (date.indexOf(87) == 6) {
            return WEEK_DATE.parse(date);
        }
        if (date.length() == 10) {
            return CALENDAR_DATE.parse(date);
        }
        if (date.length() == 8) {
            return TIME.parse(date);
        }
        return DATETIME.parse(date);
    }
}

