/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.GlobalSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    private static final Properties MEDIATYPES = new Properties();

    private FileUtils() {
    }

    public static @Nullable String getMediaType(File f) {
        String name;
        int dot;
        if (MEDIATYPES.isEmpty()) {
            FileUtils.loadMIMEProperties();
        }
        if ((dot = (name = f.getName()).lastIndexOf(".")) >= 0) {
            return MEDIATYPES.getProperty(name.substring(dot + 1));
        }
        return null;
    }

    public static boolean contains(@Nullable File root, @Nullable File file) {
        if (root == null || file == null) {
            return false;
        }
        try {
            String prefix = root.getCanonicalPath();
            return file.getCanonicalPath().startsWith(prefix);
        }
        catch (IOException | SecurityException ex) {
            return false;
        }
    }

    public static @Nullable String path(File root, File file) {
        if (root == null || file == null) {
            throw new NullPointerException("Cannot determine the path between the specified files.");
        }
        try {
            String from = root.getCanonicalPath();
            String to = file.getCanonicalPath();
            if (to.startsWith(from)) {
                String path = to.substring(from.length()).replace("\\", "/");
                return path.startsWith("/") ? path.substring(1) : path;
            }
            throw new IllegalArgumentException("Cannot determine the path between the specified files.");
        }
        catch (IOException | SecurityException ex) {
            LOGGER.warn("Unable to compute path between {} and {}", new Object[]{root, file, ex});
            return null;
        }
    }

    private static synchronized void loadMIMEProperties() {
        try (InputStream in = FileUtils.getMediaTypesInputStream();){
            if (in != null) {
                MEDIATYPES.load(in);
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to load MIME properties", (Throwable)ex);
        }
    }

    private static @Nullable InputStream getMediaTypesInputStream() throws FileNotFoundException {
        File file = new File(GlobalSettings.getWebInf(), "config/mime.properties");
        if (file.exists()) {
            LOGGER.info("Loading MIME properties from {}", (Object)file.getAbsolutePath());
            return new FileInputStream(file);
        }
        LOGGER.info("Loading MIME properties from Berlioz JAR {}", (Object)file.getAbsolutePath());
        return FileUtils.class.getResourceAsStream("/mime.properties");
    }
}

