/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public final class Errors {
    private Errors() {
    }

    public static String getStackTrace(Throwable error, boolean safe) {
        int x;
        StringWriter sw = new StringWriter();
        error.printStackTrace(new PrintWriter(sw));
        StringBuffer stacktrace = sw.getBuffer();
        if (safe && (x = stacktrace.indexOf("javax.servlet.http.HttpServlet.service")) >= 0) {
            stacktrace.setLength(x);
            stacktrace.append("...");
        }
        return stacktrace.toString();
    }

    public static String cleanMessage(Throwable ex) {
        Throwable cause = ex.getCause();
        String message = ex.getMessage();
        if (message == null) {
            message = "No message";
        }
        if (cause == null) {
            return message;
        }
        if (!message.equals(cause.getClass().getName() + ": " + cause.getMessage())) {
            return message;
        }
        return Errors.cleanMessage(cause);
    }

    public static void toXML(Exception ex, XMLWriter xml) throws IOException {
        Errors.toXML(ex, xml, true);
    }

    public static void toXML(Throwable ex, XMLWriter xml, boolean wrap) throws IOException {
        if (ex instanceof SAXParseException) {
            Errors.asSAXParseExceptionXML((SAXParseException)ex, xml, wrap);
        } else if (ex instanceof TransformerException) {
            Errors.asTransformerExceptionXML((TransformerException)ex, xml, wrap);
        } else if (ex instanceof Exception) {
            Errors.asExceptionXML((Exception)ex, xml, wrap);
        } else if (ex instanceof Error) {
            Errors.asErrorXML((Error)ex, xml, wrap);
        }
    }

    public static void toXML(SAXParseException ex, XMLWriter xml) throws IOException {
        Errors.asSAXParseExceptionXML(ex, xml, true);
    }

    public static void toXML(TransformerException ex, XMLWriter xml) throws IOException {
        Errors.asTransformerExceptionXML(ex, xml, true);
    }

    public static void toXML(@Nullable SourceLocator locator, XMLWriter xml) throws IOException {
        if (locator == null) {
            return;
        }
        int line = locator.getLineNumber();
        int column = locator.getColumnNumber();
        String publicId = locator.getPublicId();
        String systemId = locator.getSystemId();
        xml.openElement("location");
        if (line != -1) {
            xml.attribute("line", line);
        }
        if (column != -1) {
            xml.attribute("column", column);
        }
        if (publicId != null) {
            xml.attribute("public-id", publicId);
        }
        if (systemId != null) {
            xml.attribute("system-id", Errors.toWebPath(systemId));
        }
        xml.closeElement();
    }

    public static void toXML(@Nullable Locator locator, XMLWriter xml) throws IOException {
        if (locator == null) {
            return;
        }
        int line = locator.getLineNumber();
        int column = locator.getColumnNumber();
        String publicId = locator.getPublicId();
        String systemId = locator.getSystemId();
        xml.openElement("location");
        if (line != -1) {
            xml.attribute("line", line);
        }
        if (column != -1) {
            xml.attribute("column", column);
        }
        if (publicId != null) {
            xml.attribute("public-id", publicId);
        }
        if (systemId != null) {
            xml.attribute("system-id", Errors.toWebPath(systemId));
        }
        xml.closeElement();
    }

    private static String toWebPath(String s) {
        String from = "WEB-INF";
        int x = s.indexOf(from);
        return x != -1 ? s.substring(x + from.length()).replace('\\', '/') : s.replace('\\', '/');
    }

    private static Locator toLocator(SAXParseException ex) {
        LocatorImpl locator = new LocatorImpl();
        locator.setLineNumber(ex.getLineNumber());
        locator.setColumnNumber(ex.getColumnNumber());
        locator.setPublicId(ex.getPublicId());
        locator.setSystemId(ex.getSystemId());
        return locator;
    }

    private static void asExceptionXML(Exception ex, XMLWriter xml, boolean wrap) throws IOException {
        if (wrap) {
            xml.openElement("exception");
        }
        xml.attribute("class", ex.getClass().getName());
        xml.element("message", Errors.cleanMessage(ex));
        xml.element("stack-trace", Errors.getStackTrace(ex, true));
        Throwable cause = ex.getCause();
        if (cause != null) {
            xml.openElement("cause");
            Errors.toXML(cause, xml, false);
            xml.closeElement();
        }
        if (wrap) {
            xml.closeElement();
        }
    }

    private static void asErrorXML(Error ex, XMLWriter xml, boolean wrap) throws IOException {
        if (wrap) {
            xml.openElement("error");
        }
        xml.attribute("class", ex.getClass().getName());
        xml.element("message", Errors.cleanMessage(ex));
        xml.element("stack-trace", Errors.getStackTrace(ex, true));
        Throwable cause = ex.getCause();
        if (cause != null) {
            xml.openElement("cause");
            Errors.toXML(cause, xml, false);
            xml.closeElement();
        }
        if (wrap) {
            xml.closeElement();
        }
    }

    private static void asSAXParseExceptionXML(SAXParseException ex, XMLWriter xml, boolean wrap) throws IOException {
        if (wrap) {
            xml.openElement("exception");
        }
        xml.attribute("type", "SAXParseException");
        Errors.asExceptionXML(ex, xml, false);
        Errors.toXML(Errors.toLocator(ex), xml);
        if (wrap) {
            xml.closeElement();
        }
    }

    private static void asTransformerExceptionXML(TransformerException ex, XMLWriter xml, boolean wrap) throws IOException {
        boolean isConfig;
        if (wrap) {
            xml.openElement("exception");
        }
        xml.attribute("type", (isConfig = ex instanceof TransformerConfigurationException) ? "TransformerConfigurationException" : "TransformerException");
        Errors.asExceptionXML(ex, xml, false);
        Errors.toXML(ex.getLocator(), xml);
        if (wrap) {
            xml.closeElement();
        }
    }
}

