/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.pageseeder.berlioz.util.CollectedError;

public class ErrorCollector<T extends Throwable> {
    private final List<CollectedError<T>> _collected = new ArrayList<CollectedError<T>>();
    private CollectedError.Level exception = CollectedError.Level.FATAL;
    private CollectedError.Level flag = CollectedError.Level.ERROR;
    private boolean _hasError = false;

    public final void setException(CollectedError.Level threshold) {
        this.exception = Objects.requireNonNull(threshold, "Specified threshold is null");
    }

    public final void setErrorFlag(CollectedError.Level threshold) {
        this.flag = Objects.requireNonNull(threshold, "Specified threshold is null");
    }

    public final void collect(CollectedError.Level level, T exception) throws T {
        this._collected.add(new CollectedError<T>(level, exception));
        if (this.flag.compareTo(level) <= 0) {
            this._hasError = true;
        }
        if (this.exception.compareTo(level) <= 0) {
            throw exception;
        }
    }

    public final void collectQuietly(CollectedError.Level level, T exception) {
        this._collected.add(new CollectedError<T>(level, exception));
        if (this.flag.compareTo(level) <= 0) {
            this._hasError = true;
        }
    }

    public final List<CollectedError<T>> getErrors() {
        return this._collected;
    }

    public final boolean hasError() {
        return this._hasError;
    }
}

