/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozErrorID;
import org.pageseeder.berlioz.BerliozOption;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.berlioz.aeson.JSONResult;
import org.pageseeder.berlioz.content.Service;
import org.pageseeder.berlioz.servlet.XSLTransformResult;
import org.pageseeder.berlioz.util.CollectedError;
import org.pageseeder.berlioz.util.Errors;
import org.pageseeder.berlioz.util.ISO8601;
import org.pageseeder.berlioz.util.MD5;
import org.pageseeder.berlioz.xslt.XSLTErrorCollector;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public final class XSLTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(XSLTransformer.class);
    private static final Map<File, Templates> CACHE = new ConcurrentHashMap<File, Templates>();
    private static final Templates IDENTITY_TEMPLATES = new Templates(){

        @Override
        public @NonNull Transformer newTransformer() throws TransformerConfigurationException {
            return TransformerFactory.newInstance().newTransformer();
        }

        @Override
        public @NonNull Properties getOutputProperties() {
            return new Properties();
        }
    };
    private final File _templates;
    private final @Nullable URL _fallback;
    private @Nullable String etag;

    public XSLTransformer(File templates) {
        this(templates, null);
    }

    public XSLTransformer(File templates, @Nullable URL fallback) {
        this._templates = Objects.requireNonNull(templates, "The template file is required");
        this._fallback = fallback;
        this.etag = XSLTransformer.computeEtag(templates, fallback);
    }

    public XSLTransformResult transform(String content, HttpServletRequest req, Service service) {
        long time;
        Templates templates;
        StringWriter buffer = new StringWriter();
        Map<String, String> parameters = XSLTransformer.toParameters((ServletRequest)req);
        try {
            templates = this.getTemplates(this._templates);
            StreamSource source = new StreamSource(new StringReader(content));
            source.setPublicId("-//Berlioz//Service/XML/" + service.group() + "/" + service.id());
            String uri = req.getRequestURI();
            int dot = uri.lastIndexOf(46);
            if (dot >= 0) {
                source.setSystemId(req.getRequestURI().replaceAll("\\.([a-z]+)$", ".src"));
            }
            StreamResult result = new StreamResult(buffer);
            time = XSLTransformer.transform(source, result, templates, parameters);
        }
        catch (TransformerException ex) {
            String error = XSLTransformer.toXML(ex, content, parameters);
            ClassLoader loader = XSLTransformer.class.getClassLoader();
            URL url = loader.getResource("org/pageseeder/berlioz/xslt/failsafe-error-html.xsl");
            Templates failsafe = XSLTransformer.toTemplates(url);
            error = XSLTransformer.transformFailSafe(error, failsafe);
            return new XSLTransformResult((CharSequence)error, ex, failsafe);
        }
        return new XSLTransformResult((CharSequence)buffer.toString(), time, templates);
    }

    public static String transformFailSafe(String content, URL url) {
        Templates failsafe = XSLTransformer.toTemplates(url);
        return XSLTransformer.transformFailSafe(content, failsafe);
    }

    public File templates() {
        return this._templates;
    }

    public @Nullable String getEtag() {
        return this.etag;
    }

    public synchronized void clearCache() {
        LOGGER.debug("Clearing XSLT cache.");
        CACHE.remove(this._templates);
    }

    public static synchronized void clearAllCache() {
        LOGGER.debug("Clearing XSLT cache.");
        CACHE.clear();
    }

    private static @Nullable String computeEtag(File templates, @Nullable URL fallback) {
        if (!templates.exists()) {
            if (fallback != null) {
                return MD5.hash(fallback.toString());
            }
            LOGGER.error("Unable to find XSLT stylesheet '{}'.", (Object)templates.getName());
            LOGGER.error("Create a stylesheet at the path below:");
            LOGGER.error(templates.getPath());
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        File parent = templates.getParentFile();
        if (parent != null) {
            XSLTransformer.listTemplateFiles(parent, files);
        }
        StringBuilder b = new StringBuilder();
        try {
            for (File f : files) {
                b.append(MD5.hash(f, false));
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Error thrown while trying to calculate template etag", (Throwable)ex);
            return null;
        }
        return MD5.hash(b.toString());
    }

    private static void listTemplateFiles(File dir, List<File> collected) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    XSLTransformer.listTemplateFiles(f, collected);
                    continue;
                }
                collected.add(f);
            }
        } else {
            LOGGER.warn("Unable to list files from directory {}", (Object)dir.getName());
        }
    }

    private static long transform(StreamSource source, StreamResult result, Templates templates, Map<String, String> parameters) throws TransformerException {
        Transformer transformer = templates.newTransformer();
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                transformer.setParameter(e.getKey(), e.getValue());
            }
        }
        Result r = JSONResult.newInstanceIfSupported(transformer, result);
        long before = System.nanoTime();
        XSLTErrorCollector listener = new XSLTErrorCollector(LOGGER);
        transformer.setErrorListener(listener);
        try {
            transformer.transform(source, r);
        }
        catch (TransformerException ex) {
            throw new TransformerExceptionWrapper(ex, listener);
        }
        return System.nanoTime() - before;
    }

    private synchronized Templates getTemplates(File f) throws TransformerException {
        Templates templates;
        boolean store = GlobalSettings.has(BerliozOption.XSLT_CACHE);
        String stylesheet = XSLTransformer.toWebPath(f.getAbsolutePath());
        Templates templates2 = templates = store ? CACHE.get(f) : null;
        if (templates == null) {
            LOGGER.info("Loading XSLT stylesheet '{}' [caching {}]", (Object)stylesheet, (Object)(store ? "enabled" : "disabled"));
            long t0 = System.currentTimeMillis();
            templates = XSLTransformer.toTemplates(f, this._fallback);
            long t1 = System.currentTimeMillis();
            LOGGER.debug("Templates loaded in {}ms", (Object)(t1 - t0));
            this.etag = XSLTransformer.computeEtag(f, this._fallback);
            if (store) {
                CACHE.put(f, templates);
                LOGGER.info("Caching XSLT stylesheet '{}'", (Object)stylesheet);
            }
        }
        return templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Templates toTemplates(File stylepath, @Nullable URL fallback) throws TransformerException {
        Templates templates;
        FileInputStream in = null;
        try {
            in = new FileInputStream(stylepath);
            StreamSource source = new StreamSource(in);
            source.setSystemId(stylepath.toURI().toString());
            TransformerFactory factory = TransformerFactory.newInstance();
            XSLTErrorCollector listener = new XSLTErrorCollector(LOGGER);
            factory.setErrorListener(listener);
            try {
                templates = factory.newTemplates(source);
            }
            catch (TransformerConfigurationException ex) {
                throw new TransformerExceptionWrapper(ex, listener);
            }
        }
        catch (FileNotFoundException ex) {
            try {
                if (fallback == null) {
                    LOGGER.warn("Unable to find template file: {}", (Object)stylepath);
                    throw new TransformerConfigurationException("Unable to find stylesheet: " + XSLTransformer.toWebPath(stylepath.getPath()), ex);
                }
                LOGGER.warn("Unable to find template file: {} using fallback templates {}", (Object)stylepath, (Object)fallback);
                templates = XSLTransformer.toTemplates(fallback);
            }
            catch (Throwable throwable) {
                XSLTransformer.closeQuietly(in);
                throw throwable;
            }
            XSLTransformer.closeQuietly(in);
        }
        XSLTransformer.closeQuietly(in);
        return templates;
    }

    private static Map<String, String> toParameters(ServletRequest req) {
        HashMap<String, String> p = null;
        int xsl_prefix = 4;
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = req.getParameter(name);
            if (name == null || value == null || !name.startsWith("xsl-")) continue;
            if (p == null) {
                p = new HashMap<String, String>();
            }
            p.put(name.substring(4), value);
        }
        if (p != null) {
            return p;
        }
        return Collections.emptyMap();
    }

    private static String toXML(TransformerException ex, String source, Map<String, String> parameters) {
        StringWriter out = new StringWriter();
        try {
            TransformerExceptionWrapper wrapper;
            TransformerException wrapped;
            XMLWriterImpl xml = new XMLWriterImpl((Writer)out);
            xml.openElement("server-error");
            xml.attribute("http-code", 503);
            xml.attribute("datetime", ISO8601.format(System.currentTimeMillis(), ISO8601.DATETIME));
            TransformerException actual = ex;
            XSLTErrorCollector collector = null;
            if (ex instanceof TransformerExceptionWrapper && (wrapped = (TransformerException)(wrapper = (TransformerExceptionWrapper)ex).getException()) != null) {
                actual = wrapped;
                collector = wrapper.collector();
            }
            BerliozErrorID id = XSLTransformer.toErrorID(actual);
            xml.attribute("id", id.id());
            xml.openElement("berlioz");
            xml.attribute("version", GlobalSettings.getVersion());
            xml.closeElement();
            xml.element("title", XSLTransformer.toTitle(id));
            xml.element("message", Errors.cleanMessage(ex));
            Errors.toXML(actual, (XMLWriter)xml);
            if (collector != null) {
                xml.openElement("collected-errors");
                for (CollectedError collectedError : collector.getErrors()) {
                    collectedError.toXML((XMLWriter)xml);
                }
                xml.closeElement();
            }
            if (parameters != null) {
                xml.openElement("parameters");
                for (Map.Entry entry : parameters.entrySet()) {
                    xml.openElement("parameter");
                    xml.attribute("name", (String)entry.getKey());
                    xml.attribute("value", (String)entry.getValue());
                    xml.closeElement();
                }
                xml.closeElement();
            }
            xml.closeElement();
            xml.flush();
        }
        catch (IOException io) {
            LOGGER.warn("Unable to produce transform error details for error below:");
            LOGGER.error("An error occurred while transforming content", (Throwable)ex);
        }
        return out.toString();
    }

    private static Templates toTemplates(@Nullable URL url) {
        Templates templates;
        if (url == null) {
            return IDENTITY_TEMPLATES;
        }
        try (InputStream in = url.openStream();){
            StreamSource source = new StreamSource(in);
            source.setSystemId(url.toString());
            TransformerFactory factory = TransformerFactory.newInstance();
            templates = factory.newTemplates(source);
        }
        catch (IOException | TransformerException ex) {
            LOGGER.warn("Unable to load fallback/failsafe templates!", (Throwable)ex);
            return IDENTITY_TEMPLATES;
        }
        return templates;
    }

    private static String transformFailSafe(String xml, Templates templates) {
        String out;
        if (templates == IDENTITY_TEMPLATES) {
            return xml;
        }
        try {
            StreamSource source = new StreamSource(new StringReader(xml));
            StringWriter html = new StringWriter();
            StreamResult result = new StreamResult(html);
            templates.newTransformer().transform(source, result);
            out = html.toString();
        }
        catch (TransformerException disaster) {
            LOGGER.error("Fail-safe stylesheet failed! - returning error details as XML: {}", (Object)disaster.getMessageAndLocation());
            out = xml;
        }
        catch (Exception catastrophe) {
            LOGGER.error("Fail-safe stylesheet failed! - returning error details as XML", (Throwable)catastrophe);
            out = xml;
        }
        return out;
    }

    private static String toWebPath(String s) {
        String from = "WEB-INF";
        int x = s.indexOf(from);
        return x != -1 ? s.substring(x + from.length()).replace('\\', '/') : s.replace('\\', '/');
    }

    private static void closeQuietly(@Nullable InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                LOGGER.debug("Error thrown while trying to quietly close stream - ignored", (Throwable)ex);
            }
        }
    }

    private static BerliozErrorID toErrorID(TransformerException ex) {
        if (ex instanceof TransformerConfigurationException) {
            if (ex.getCause() instanceof FileNotFoundException) {
                return BerliozErrorID.TRANSFORM_NOT_FOUND;
            }
            return BerliozErrorID.TRANSFORM_INVALID;
        }
        if (ex.getCause() instanceof SAXParseException) {
            return BerliozErrorID.TRANSFORM_MALFORMED_SOURCE_XML;
        }
        return BerliozErrorID.TRANSFORM_DYNAMIC_ERROR;
    }

    private static String toTitle(BerliozErrorID id) {
        switch (id) {
            case TRANSFORM_NOT_FOUND: {
                return "XSLT Not Found";
            }
            case TRANSFORM_INVALID: {
                return "XSLT Static Error";
            }
            case TRANSFORM_DYNAMIC_ERROR: {
                return "XSLT Dynamic Error";
            }
            case TRANSFORM_MALFORMED_SOURCE_XML: {
                return "XML is not well formed";
            }
        }
        return "Unindentified XSLT error!";
    }

    private static class TransformerExceptionWrapper
    extends TransformerException {
        private static final long serialVersionUID = -7816677212503520650L;
        private final XSLTErrorCollector _collector;

        public TransformerExceptionWrapper(TransformerException ex, XSLTErrorCollector collector) {
            super(ex);
            this._collector = collector;
        }

        public XSLTErrorCollector collector() {
            return this._collector;
        }
    }
}

