/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozErrorID;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.content.Cacheable;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentStatus;
import org.pageseeder.berlioz.content.GeneratorListener;
import org.pageseeder.berlioz.content.MatchingService;
import org.pageseeder.berlioz.content.Parameter;
import org.pageseeder.berlioz.content.Service;
import org.pageseeder.berlioz.content.ServiceStatusRule;
import org.pageseeder.berlioz.http.ServerTimingHeader;
import org.pageseeder.berlioz.servlet.BerliozConfig;
import org.pageseeder.berlioz.servlet.CoreHttpRequest;
import org.pageseeder.berlioz.servlet.HttpContentRequest;
import org.pageseeder.berlioz.servlet.HttpRequestWrapper;
import org.pageseeder.berlioz.servlet.XMLResponseHeader;
import org.pageseeder.berlioz.util.CollectedError;
import org.pageseeder.berlioz.util.CompoundBerliozException;
import org.pageseeder.berlioz.util.ErrorCollector;
import org.pageseeder.berlioz.util.Errors;
import org.pageseeder.berlioz.util.ProfileFormat;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMLResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLResponse.class);
    private static volatile @Nullable GeneratorListener listener = null;
    private final CoreHttpRequest _core;
    private final MatchingService _match;
    private final List<HttpContentRequest> _requests;
    private final Map<Integer, String> _etags = new HashMap<Integer, String>();
    private final boolean _profile;
    private @Nullable ContentStatus status = null;
    private @Nullable String redirect = null;
    private @Nullable BerliozException exception = null;
    private boolean serverTiming;

    public XMLResponse(HttpServletRequest req, HttpServletResponse res, BerliozConfig config, MatchingService match, boolean profile) {
        this._core = new CoreHttpRequest(req, res, config.getEnvironment());
        this._match = match;
        this._requests = XMLResponse.configure(this._core, match);
        this._profile = profile;
    }

    public void enableServerTiming() {
        this.serverTiming = true;
    }

    public Service getService() {
        return this._match.service();
    }

    public @Nullable String getEtag() {
        Service service = this._match.service();
        boolean cacheable = service.isCacheable();
        StringBuilder etag = new StringBuilder();
        if (cacheable) {
            for (HttpContentRequest request : this._requests) {
                ContentGenerator generator = request.generator();
                if (generator instanceof Cacheable) {
                    String localtag = this.getETag(request);
                    if (localtag.isEmpty()) {
                        return null;
                    }
                    etag.append(localtag).append('/');
                    continue;
                }
                cacheable = false;
                break;
            }
        }
        return cacheable ? etag.toString() : null;
    }

    public ContentStatus getStatus() {
        ContentStatus status = this.status;
        return status == null ? ContentStatus.OK : status;
    }

    public @Nullable BerliozException getError() {
        return this.exception;
    }

    public @Nullable String getRedirectURL() {
        return this.redirect;
    }

    public String generate() throws IOException {
        StringWriter writer = new StringWriter();
        XMLWriterImpl xml = new XMLWriterImpl((Writer)writer);
        xml.xmlDecl();
        xml.openElement("root", true);
        Service service = this._match.service();
        xml.attribute("service", service.id());
        xml.attribute("group", service.group());
        if (service.flags() != null) {
            xml.attribute("flags", service.flags());
        }
        XMLResponseHeader header = new XMLResponseHeader(this._core, service, this._match.result());
        header.toXML((XMLWriter)xml);
        int position = 0;
        for (HttpContentRequest request : this._requests) {
            this.toXML(request, ++position, service, (XMLWriter)xml);
        }
        xml.closeElement();
        xml.flush();
        return writer.toString();
    }

    @Beta
    static synchronized void setListener(GeneratorListener listener) {
        XMLResponse.listener = listener;
    }

    @Beta
    static synchronized @Nullable GeneratorListener getListener() {
        return listener;
    }

    private void toXML(HttpContentRequest request, int position, Service service, XMLWriter xml) throws IOException {
        GeneratorListener l;
        String etag;
        ContentGenerator generator = request.generator();
        xml.openElement("content", true);
        xml.attribute("generator", generator.getClass().getName());
        String name = service.name(generator);
        xml.attribute("name", name);
        String target = service.target(generator);
        if (target != null) {
            xml.attribute("target", target);
        }
        if (generator instanceof Cacheable && (etag = this.getETag(request)).length() > 0) {
            xml.attribute("etag", etag);
        }
        if (generator.getClass().isAnnotationPresent(Deprecated.class)) {
            xml.attribute("deprecated", "true");
        }
        String result = null;
        BerliozException error = null;
        ContentStatus status = ContentStatus.OK;
        long start = System.nanoTime();
        try {
            StringWriter writer = new StringWriter();
            XMLWriterImpl ok = new XMLWriterImpl((Writer)writer);
            generator.process(request, (XMLWriter)ok);
            result = writer.toString();
            status = request.getStatus();
        }
        catch (Exception ex) {
            error = this.handleError(ex, generator);
            status = ContentStatus.INTERNAL_SERVER_ERROR;
        }
        long end = System.nanoTime();
        boolean wasSet = this.handleStatus(status, generator, service);
        if (wasSet && ContentStatus.isRedirect(status)) {
            this.redirect = request.getRedirectURL();
        }
        xml.attribute("status", status.toString());
        if (this._profile) {
            xml.attribute("profile-etag", ProfileFormat.format(request.getProfileEtag()));
            xml.attribute("profile-process", ProfileFormat.format(end - start));
            xml.attribute("profile", ProfileFormat.format(request.getProfileEtag() + end - start));
        }
        if (this.serverTiming) {
            String safeName = name.replaceAll("[^!#$%&'*+\\-.^_`|~0-9a-zA-Z]", "_");
            ServerTimingHeader.addMetricNano(this._core.response(), "xml" + position, "Source " + safeName, request.getProfileEtag() + end - start);
        }
        if ((l = listener) != null) {
            l.generate(service, generator, status, request.getProfileEtag(), end - start);
        }
        if (error != null) {
            xml.openElement("berlioz-exception");
            Errors.toXML(error, xml, false);
            xml.closeElement();
        } else {
            xml.writeXML(result);
        }
        xml.closeElement();
    }

    private static List<HttpContentRequest> configure(CoreHttpRequest core, MatchingService match) {
        Map<String, String> common = HttpRequestWrapper.toParameters(core.request(), match.result());
        Service service = match.service();
        ArrayList<HttpContentRequest> requests = new ArrayList<HttpContentRequest>();
        int order = 0;
        for (ContentGenerator generator : service.generators()) {
            List<Parameter> pconfig = service.parameters(generator);
            if (pconfig.isEmpty()) {
                requests.add(new HttpContentRequest(core, common, generator, match.service(), order));
            } else {
                HashMap<String, String> specific = new HashMap<String, String>(common);
                for (Parameter p : pconfig) {
                    specific.put(p.name(), p.value(common));
                }
                requests.add(new HttpContentRequest(core, specific, generator, match.service(), order));
            }
            ++order;
        }
        return requests;
    }

    private BerliozException handleError(Exception exception, ContentGenerator generator) {
        BerliozException ex;
        BerliozException bex;
        LOGGER.warn("Handling " + exception.getClass().getName() + " thrown by " + generator.getClass().getName());
        if (exception instanceof BerliozException) {
            bex = (BerliozException)exception;
            if (bex.id() == null) {
                bex.setId(BerliozErrorID.GENERATOR_ERROR_UNFORCED);
            }
        } else {
            bex = new BerliozException("Unexpected exception caught", exception, BerliozErrorID.GENERATOR_ERROR_UNCHECKED);
        }
        if ((ex = this.exception) == null) {
            this.exception = ex = bex;
        } else {
            ErrorCollector<Throwable> collector;
            CompoundBerliozException compound;
            CompoundBerliozException compoundBerliozException = compound = ex instanceof CompoundBerliozException ? (CompoundBerliozException)ex : null;
            if (compound != null) {
                collector = compound.getCollector();
            } else {
                collector = new ErrorCollector();
                compound = new CompoundBerliozException("Multiple errors thrown by generators", BerliozErrorID.GENERATOR_ERROR_MULTIPLE, collector);
                Throwable t = ex.getCause();
                collector.collectQuietly(CollectedError.Level.ERROR, t != null ? (Exception)t : ex);
                ex = compound;
            }
            collector.collectQuietly(CollectedError.Level.ERROR, exception);
        }
        return bex;
    }

    private boolean handleStatus(ContentStatus status, ContentGenerator generator, Service service) {
        boolean relevant = service.affectStatus(generator);
        if (relevant) {
            ServiceStatusRule r = service.rule();
            ServiceStatusRule.CodeRule rule = r.rule();
            ContentStatus s = this.status;
            if (s == null) {
                this.status = status;
                return true;
            }
            if (rule == ServiceStatusRule.CodeRule.HIGHEST && status.code() > s.code()) {
                this.status = status;
                return true;
            }
            if (rule == ServiceStatusRule.CodeRule.LOWEST && status.code() < s.code()) {
                this.status = status;
                return true;
            }
        }
        return false;
    }

    private String getETag(HttpContentRequest request) {
        String etag = null;
        Integer key = request.order();
        if (this._etags.containsKey(key)) {
            etag = this._etags.get(key);
        } else {
            ContentGenerator generator = request.generator();
            if (generator instanceof Cacheable) {
                long start = System.nanoTime();
                etag = ((Cacheable)((Object)generator)).getETag(request);
                long end = System.nanoTime();
                request.setProfileEtag(end - start);
            }
            this._etags.put(key, etag != null ? etag : "");
        }
        return etag != null ? etag : "";
    }
}

