/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.security;

import java.security.SecureRandom;
import java.util.Base64;

public final class NonceFactory {
    private final SecureRandom r = new SecureRandom();
    private final Base64.Encoder encoder = Base64.getEncoder().withoutPadding();
    private static final int DEFAULT_LENGTH = 16;
    private final int length;

    public NonceFactory() {
        this.length = 16;
    }

    public NonceFactory(int length) {
        if (length < 4 || length > 256) {
            throw new IllegalArgumentException();
        }
        this.length = length;
    }

    public String generate() {
        byte[] bytes = new byte[this.length];
        this.r.nextBytes(bytes);
        return this.encoder.encodeToString(bytes);
    }
}

