/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.generator;

import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.content.Cacheable;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.content.Service;
import org.pageseeder.berlioz.content.ServiceLoader;
import org.pageseeder.berlioz.content.ServiceRegistry;
import org.pageseeder.berlioz.http.HttpMethod;
import org.pageseeder.berlioz.servlet.HttpEnvironment;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class GetLiveServices
implements ContentGenerator,
Cacheable {
    @Override
    public @NonNull String getETag(ContentRequest req) {
        ServiceRegistry registry = ServiceLoader.getInstance().getDefaultRegistry();
        return Long.toString(registry.version());
    }

    @Override
    public void process(ContentRequest req, XMLWriter xml) throws IOException {
        ServiceRegistry registry = ServiceLoader.getInstance().getDefaultRegistry();
        xml.openElement("live-services", true);
        HttpEnvironment httpEnv = (HttpEnvironment)req.getEnvironment();
        for (HttpMethod method : HttpMethod.mappable()) {
            List<Service> services = registry.getServices(method);
            for (Service service : services) {
                List<String> urls = registry.matches(service);
                service.toXML(xml, method, urls, httpEnv.getCacheControl());
            }
        }
        xml.closeElement();
    }
}

