/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.furi;

import org.pageseeder.berlioz.furi.BerliozTokenOperator;
import org.pageseeder.berlioz.furi.Token;
import org.pageseeder.berlioz.furi.TokenLiteral;
import org.pageseeder.berlioz.furi.TokenVariable;
import org.pageseeder.berlioz.furi.Variable;

public final class TokenFactory {
    private static final TokenFactory FACTORY = new TokenFactory(Syntax.DRAFTX);
    private final Syntax _syntax;

    private TokenFactory(Syntax syntax) {
        this._syntax = syntax;
    }

    public Token newToken(String exp) {
        if (exp.length() == 0) {
            return TokenLiteral.EMPTY;
        }
        if ("*".equals(exp)) {
            return TokenFactory.newWildcard();
        }
        int len = exp.length();
        if (len < 2) {
            return new TokenLiteral(exp);
        }
        if (exp.charAt(0) == '{' && exp.charAt(len - 1) == '}') {
            return this._syntax.newExpansion(exp.substring(1, len - 1));
        }
        return new TokenLiteral(exp);
    }

    private static Token newWildcard() {
        return new BerliozTokenOperator(BerliozTokenOperator.Operator.URI_INSERT, new Variable(Variable.Reserved.WILDCARD));
    }

    public static TokenFactory getInstance() {
        return FACTORY;
    }

    public static TokenFactory getInstance(Syntax syntax) {
        return new TokenFactory(syntax);
    }

    public static enum Syntax {
        DRAFTX{

            @Override
            protected Token newExpansion(String exp) {
                if (!Character.isLetter(exp.charAt(0)) && !Character.isDigit(exp.charAt(0))) {
                    return BerliozTokenOperator.parse(exp);
                }
                if (exp.indexOf(44) >= 0) {
                    return BerliozTokenOperator.parse(exp);
                }
                return new TokenVariable(Variable.parse(exp));
            }
        };


        protected abstract Token newExpansion(String var1);
    }
}

