/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.content;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.Parameter;
import org.pageseeder.berlioz.content.Service;
import org.pageseeder.berlioz.content.ServiceRegistry;
import org.pageseeder.berlioz.content.ServiceStatusRule;
import org.pageseeder.berlioz.furi.URIPattern;
import org.pageseeder.berlioz.generator.NoContent;
import org.pageseeder.berlioz.http.HttpMethod;
import org.pageseeder.berlioz.util.Pair;
import org.pageseeder.berlioz.xml.SAXErrorCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class ServicesHandler10
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesHandler10.class);
    private final ServiceRegistry _registry;
    private final SAXErrorCollector _collector;
    private final List<URIPattern> _patterns = new ArrayList<URIPattern>();
    private HttpMethod method = HttpMethod.GET;
    private @Nullable Locator locator;
    private final Service.Builder _builder = new Service.Builder();
    private final List<ServiceStatusRule> _rules = new ArrayList<ServiceStatusRule>();
    private final Set<Pair<HttpMethod, URIPattern>> _patternsToMethod = new HashSet<Pair<HttpMethod, URIPattern>>();
    private final Set<String> _groups = new HashSet<String>();

    public ServicesHandler10(ServiceRegistry registry, SAXErrorCollector collector) {
        this._registry = Objects.requireNonNull(registry, "service registry is required");
        this._collector = Objects.requireNonNull(collector, "error collector is required");
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this._collector.hasError()) {
            return;
        }
        Element element = Element.get(localName);
        if (element == null) {
            this.warning("Unknown element " + localName + " found");
            return;
        }
        switch (element) {
            case SERVICE_CONFIG: {
                this._registry.clear();
                break;
            }
            case SERVICES: {
                String group = atts.getValue("group");
                this._builder.group(group);
                if (!this._groups.add(this._builder.group())) {
                    this.warning("Duplicate group of services '" + group + "' - services will belong to the same group");
                }
                if (this._rules.size() != 0) break;
                this._rules.add(ServiceStatusRule.DEFAULT_RULE);
                break;
            }
            case SERVICE: {
                String id;
                if (this._rules.size() == 1) {
                    this._rules.add(ServiceStatusRule.DEFAULT_RULE);
                }
                this._builder.id((id = atts.getValue("id")) != null ? id : "");
                this._builder.cache(atts.getValue("cache-control"));
                this._builder.flags(atts.getValue("flags"));
                this.handleMethod(atts.getValue("method"));
                break;
            }
            case URL: {
                this.handlePattern(atts.getValue("pattern"));
                break;
            }
            case PARAMETER: {
                this._builder.parameter(this.toParameter(atts));
                break;
            }
            case RESPONSE_CODE: {
                this.handleResponseCode(atts.getValue("use"), atts.getValue("rule"));
                break;
            }
            case GENERATOR: {
                this.handleGenerator(atts);
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this._collector.hasError()) {
            return;
        }
        Element element = Element.get(localName);
        if (element == null) {
            return;
        }
        switch (element) {
            case SERVICE: {
                HttpMethod method = this.method;
                this._builder.rule(this._rules.get(this._rules.size() - 1));
                if (!"".equals(this._builder.id())) {
                    Service service = this._builder.build();
                    if (this._patterns.isEmpty()) {
                        this.warning("No URI pattern match service " + service.id() + " - service will be ignored");
                    } else {
                        for (URIPattern pattern : this._patterns) {
                            this._registry.register(service, pattern, method);
                            LOGGER.debug("Assigning {}} [{}}] to {}", new Object[]{pattern, method, service});
                        }
                    }
                } else {
                    this.warning("Service cannot be created without an id");
                }
                this._builder.reset();
                this._patterns.clear();
                if (this._rules.size() != 3) break;
                this._rules.remove(2);
                break;
            }
            case SERVICES: {
                if (this._rules.size() != 2) break;
                this._rules.remove(1);
                break;
            }
            case SERVICE_CONFIG: {
                if (this._rules.size() != 1) break;
                this._rules.remove(0);
                break;
            }
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this._collector.warning(ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this._collector.error(ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this._collector.fatalError(ex);
    }

    private @Nullable Parameter toParameter(Attributes atts) throws SAXException {
        String name = atts.getValue("name");
        String value = atts.getValue("value");
        if (name == null || value == null) {
            this.warning("Bad parameter specifications - ignoring");
            return null;
        }
        return new Parameter(name, value);
    }

    private void handlePattern(@Nullable String pattern) throws SAXException {
        if (pattern == null) {
            this.warning("Ignoring null pattern", null);
            return;
        }
        try {
            URIPattern p = new URIPattern(pattern);
            Pair<HttpMethod, URIPattern> k = new Pair<HttpMethod, URIPattern>(this.method, p);
            if (this._patternsToMethod.add(k)) {
                this._patterns.add(p);
            } else {
                this.warning("Ignoring duplicate pattern '" + p + "'", null);
            }
        }
        catch (IllegalArgumentException ex) {
            this.warning("Ignoring invalid pattern '" + pattern + "'", ex);
        }
    }

    private void handleResponseCode(@Nullable String use, @Nullable String rule) throws SAXException {
        if (use == null) {
            this.warning("Ignoring response code rule: @use is null", null);
            return;
        }
        try {
            this._rules.add(ServiceStatusRule.newInstance(use, rule));
        }
        catch (IllegalArgumentException ex) {
            this.warning("Ignoring bad response code definition: " + ex.getMessage(), ex);
        }
    }

    private void handleMethod(@Nullable String method) throws SAXException {
        if (method == null) {
            this.warning("Ignoring null method for service id " + this._builder.id() + " defaulting to GET");
            this.method = HttpMethod.GET;
        } else {
            try {
                this.method = HttpMethod.valueOf(method.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                this.warning("Ignoring illegal method '" + method + "' for service id " + this._builder.id(), ex);
            }
        }
    }

    private void handleGenerator(Attributes atts) throws SAXException {
        String className = atts.getValue("class");
        try {
            ContentGenerator generator = className == null || className.length() == 0 ? new NoContent() : (ContentGenerator)Class.forName(className).newInstance();
            this._builder.add(generator);
            this._builder.target(atts.getValue("target"));
            this._builder.name(atts.getValue("name"));
        }
        catch (NoClassDefFoundError error) {
            ClassNotFoundException ex = new ClassNotFoundException("Class definition problem", error);
            this.warning("Failed to create generator " + className + " for service " + this._builder.id(), ex);
        }
        catch (ClassNotFoundException ex) {
            this.warning("Failed to find generator " + className + " for service " + this._builder.id(), ex);
        }
        catch (IllegalAccessException ex) {
            this.warning("Failed to access generator " + className + " for service " + this._builder.id(), ex);
        }
        catch (InstantiationException ex) {
            this.warning("Failed to instantiate generator " + className + " for service " + this._builder.id(), ex);
        }
    }

    public void warning(String message) throws SAXException {
        SAXParseException warning = new SAXParseException(message, this.locator);
        this.warning(warning);
    }

    public void warning(String message, @Nullable Exception ex) throws SAXException {
        SAXParseException warning = new SAXParseException(message, this.locator, ex);
        this.warning(warning);
    }

    private static enum Element {
        GENERATOR,
        PARAMETER,
        SERVICE_CONFIG,
        SERVICES,
        SERVICE,
        RESPONSE_CODE,
        URL;

        private final String _name = this.name().toLowerCase().replace('_', '-');

        public static @Nullable Element get(String name) {
            for (Element element : Element.values()) {
                if (!element._name.equals(name)) continue;
                return element;
            }
            return null;
        }

        public String toString() {
            return this._name;
        }
    }
}

