/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.aeson;

import java.io.File;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.aeson.JSONResult;

public final class Aeson {
    public static void main(String[] args) throws Exception {
        Transformer transformer;
        File source = Aeson.getFile(args, "-s:");
        File style = Aeson.getFile(args, "-xsl:");
        File output = Aeson.getFile(args, "-o:");
        if (source == null || !source.exists()) {
            System.err.println("Unable to process source: " + source);
            System.exit(0);
            return;
        }
        if (source.isDirectory() && (output == null || output.isFile())) {
            System.err.println("When source is a directory, the output must be specified and be a directory");
            System.exit(0);
            return;
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        if (style != null) {
            StreamSource xslt = new StreamSource(style);
            transformer = factory.newTransformer(xslt);
        } else {
            transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("media-type", "application/json");
        }
        if (source.isDirectory()) {
            File[] files;
            if (output != null && !output.exists()) {
                output.mkdirs();
            }
            if ((files = source.listFiles()) != null) {
                for (File f : files) {
                    StreamSource s = new StreamSource(f);
                    StreamResult r = new StreamResult(new File(output, Aeson.toOutputName(f.getName(), transformer)));
                    Result result = JSONResult.newInstanceIfSupported(transformer, r);
                    transformer.transform(s, result);
                }
            } else {
                System.err.println("Unable to list source files");
                System.exit(0);
            }
        } else {
            StreamSource s = new StreamSource(source);
            StreamResult r = output != null ? new StreamResult(output) : new StreamResult(System.out);
            Result result = JSONResult.newInstanceIfSupported(transformer, r);
            transformer.transform(s, result);
        }
    }

    private static @Nullable File getFile(String[] args, String prefix) {
        String value = Aeson.getByPrefix(args, prefix);
        if (value != null) {
            return new File(value);
        }
        return null;
    }

    private static @Nullable String getByPrefix(String[] args, String prefix) {
        for (String arg : args) {
            if (!arg.startsWith(prefix)) continue;
            return arg.substring(prefix.length());
        }
        return null;
    }

    private static String toOutputName(String name, Transformer transformer) {
        String withoutExt;
        String method = transformer.getOutputProperty("method");
        String media = transformer.getOutputProperty("media-type");
        int dot = name.lastIndexOf(46);
        String string = withoutExt = dot >= 0 ? name.substring(0, dot) : name;
        if ("xml".equals(method)) {
            if ("application/json".equals(media)) {
                return withoutExt + ".json";
            }
            return withoutExt + ".xml";
        }
        if ("html".equals(method)) {
            return withoutExt + ".html";
        }
        if ("text".equals(method)) {
            return withoutExt + ".txt";
        }
        return name;
    }
}

