/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.util;

import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class Rules {
    private static final String HOST_PATTERN = "(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.?){1,200}[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";
    private static final Pattern HOST = Pattern.compile("(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.?){1,200}[a-z0-9](?:[a-z0-9-]*[a-z0-9])?", 2);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;

    private Rules() {
    }

    public static boolean isValidHost(@Nullable String host) {
        if (host == null || host.isEmpty()) {
            return false;
        }
        char c = host.toLowerCase().charAt(host.length() - 1);
        if (!('a' <= c && c <= 'z' || '0' <= c && c <= '9')) {
            return false;
        }
        return HOST.matcher(host).matches();
    }

    public static @Nullable String uriEncodedPathToDBPath(@Nullable String encodedPath) {
        if (encodedPath == null) {
            return null;
        }
        int plus = encodedPath.indexOf("%20");
        if (plus == -1) {
            return encodedPath;
        }
        return encodedPath.replaceAll("%20", "+");
    }

    public static @Nullable String uriDBPathToEncodedPath(@Nullable String dbPath) {
        if (dbPath == null) {
            return null;
        }
        int plus = dbPath.indexOf(43);
        if (plus == -1) {
            return dbPath;
        }
        int qm = dbPath.indexOf(63);
        String before = qm == -1 ? dbPath : dbPath.substring(0, qm);
        String after = qm == -1 ? "" : dbPath.substring(qm);
        StringBuilder p = new StringBuilder();
        for (char c : before.toCharArray()) {
            if ('+' == c) {
                p.append("%20");
                continue;
            }
            p.append(c);
        }
        p.append(after);
        return p.toString();
    }

    public static int getDefaultPort(String protocol) {
        return "https".equalsIgnoreCase(protocol) ? 443 : 80;
    }
}

