/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.util;

import com.pageseeder.common.util.Base64;
import com.pageseeder.common.util.Hex;
import java.nio.charset.Charset;
import java.util.Arrays;

public enum BinaryFormat {
    HEX{

        @Override
        public String encode(byte[] bytes) {
            return Hex.encode(bytes);
        }

        @Override
        public byte[] decode(String s) {
            return Hex.decode(s);
        }
    }
    ,
    BASE_64{

        @Override
        public String encode(byte[] bytes) {
            return new String(Base64.encode(bytes));
        }

        @Override
        public byte[] decode(String s) throws IllegalArgumentException {
            return Base64.decode(s.toCharArray());
        }
    }
    ,
    BASE_64_URL{

        @Override
        public String encode(byte[] bytes) {
            char[] base64 = Base64.encode(bytes);
            int length = base64.length;
            for (int i = 0; i < base64.length; ++i) {
                char c = base64[i];
                if (c == '+') {
                    base64[i] = 45;
                    continue;
                }
                if (c == '/') {
                    base64[i] = 95;
                    continue;
                }
                if (c != '=') continue;
                length = i;
                break;
            }
            return new String(base64, 0, length);
        }

        @Override
        public byte[] decode(String s) throws IllegalArgumentException {
            char[] array = s.toCharArray();
            for (int i = 0; i < array.length; ++i) {
                char c = array[i];
                if (c == '-') {
                    array[i] = 43;
                }
                if (c != '_') continue;
                array[i] = 47;
            }
            int originalLength = array.length;
            int mod = array.length % 4;
            if (mod != 0) {
                int newLength = originalLength + 4 - mod;
                array = Arrays.copyOf(array, newLength);
                Arrays.fill(array, originalLength, newLength, '=');
            }
            return Base64.decode(array);
        }
    };


    public abstract String encode(byte[] var1);

    public String encode(String data, Charset charset) {
        return this.encode(data.getBytes(charset));
    }

    public abstract byte[] decode(String var1) throws IllegalArgumentException;

    public String decode(String data, Charset charset) {
        byte[] bytes = this.decode(data);
        return new String(bytes, charset);
    }
}

