/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class Base64 {
    private static final char[] BASE64_ENCODE;
    private static final char[] BASE64URL_ENCODE;
    private static final byte[] BASE64_DECODE;
    private static final byte[] BASE64URL_DECODE;

    private Base64() {
    }

    public static char[] encode(byte[] bytes) {
        int mask = 255;
        int iLen = bytes.length;
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i0 = bytes[ip++] & 0xFF;
            int i1 = ip < iLen ? bytes[ip++] & 0xFF : 0;
            int i2 = ip < iLen ? bytes[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = BASE64_ENCODE[o0];
            out[op++] = BASE64_ENCODE[o1];
            out[op] = op < oDataLen ? BASE64_ENCODE[o2] : 61;
            int n = ++op < oDataLen ? BASE64_ENCODE[o3] : 61;
            out[op] = n;
            ++op;
        }
        return out;
    }

    public static char[] encodeURL(byte[] in) {
        int mask = 255;
        int iLen = in.length;
        int oDataLen = (iLen * 4 + 2) / 3;
        char[] out = new char[oDataLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iLen ? in[ip++] & 0xFF : 0;
            int i2 = ip < iLen ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = BASE64URL_ENCODE[o0];
            out[op++] = BASE64URL_ENCODE[o1];
            if (op < oDataLen) {
                out[op] = BASE64URL_ENCODE[o2];
            }
            if (++op < oDataLen) {
                out[op] = BASE64URL_ENCODE[o3];
            }
            ++op;
        }
        return out;
    }

    public static String decode(String s, String encoding) throws IllegalArgumentException, UnsupportedEncodingException {
        return new String(Base64.decode(s.toCharArray()), encoding);
    }

    public static String decode(String s, Charset charset) throws IllegalArgumentException {
        return new String(Base64.decode(s.toCharArray()), charset);
    }

    public static byte[] decode(char[] data) throws IllegalArgumentException {
        int iLen = data.length;
        if (iLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (iLen > 0 && data[iLen - 1] == '=') {
            --iLen;
        }
        return Base64.decode(data, iLen, BASE64_DECODE);
    }

    public static byte[] decodeURL(char[] data) throws IllegalArgumentException {
        int iLen = data.length;
        if (iLen % 4 == 1) {
            throw new IllegalArgumentException("Illegal length of Base64 encoded input string.");
        }
        return Base64.decode(data, data.length, BASE64URL_DECODE);
    }

    private static byte[] decode(char[] in, int iLen, byte[] mapping) throws IllegalArgumentException {
        int lastASCII = 127;
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i3;
            char i0 = in[ip++];
            char i1 = in[ip++];
            int i2 = ip < iLen ? in[ip++] : 65;
            int n = i3 = ip < iLen ? in[ip++] : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0 = mapping[i0];
            byte b1 = mapping[i1];
            byte b2 = mapping[i2];
            byte b3 = mapping[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    static {
        int c;
        BASE64_ENCODE = new char[64];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64.BASE64_ENCODE[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64.BASE64_ENCODE[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64.BASE64_ENCODE[i++] = c;
        }
        Base64.BASE64_ENCODE[i++] = 43;
        Base64.BASE64_ENCODE[i++] = 47;
        BASE64URL_ENCODE = new char[64];
        i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64.BASE64URL_ENCODE[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64.BASE64URL_ENCODE[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64.BASE64URL_ENCODE[i++] = c;
        }
        Base64.BASE64URL_ENCODE[i++] = 45;
        Base64.BASE64URL_ENCODE[i++] = 95;
        BASE64_DECODE = new byte[128];
        Arrays.fill(BASE64_DECODE, (byte)-1);
        for (i = 0; i < 64; ++i) {
            Base64.BASE64_DECODE[Base64.BASE64_ENCODE[i]] = (byte)i;
        }
        BASE64URL_DECODE = new byte[128];
        Arrays.fill(BASE64URL_DECODE, (byte)-1);
        for (i = 0; i < 64; ++i) {
            Base64.BASE64URL_DECODE[Base64.BASE64URL_ENCODE[i]] = (byte)i;
        }
    }
}

