/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.properties;

import com.pageseeder.common.properties.DatabaseSettings;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.common.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Settings {
    private static final Logger LOGGER = LoggerFactory.getLogger(Settings.class);
    public static final Integer CURRENT_INDEX_VERSION = 91100;
    private static final Map<SettingsFile, Properties> PROPERTIES_BY_FILE = Collections.synchronizedMap(new EnumMap(SettingsFile.class));
    private static final Map<SettingsFile, String> COMMENTS_BY_FILE = Collections.synchronizedMap(new EnumMap(SettingsFile.class));
    private static @Nullable String contextPath = null;
    private static @Nullable ServletContext servletContext = null;

    private Settings() {
    }

    public static @Nullable String get(SettingsFile file, String name) {
        Properties props;
        if (file == SettingsFile.MIME) {
            name = name.toLowerCase();
        }
        if (file == SettingsFile.TEMPLATE) {
            file = SettingsFile.GLOBAL;
        }
        if ((props = PROPERTIES_BY_FILE.get((Object)file)) == null) {
            return null;
        }
        String value = props.getProperty(name);
        if (value == null && file == SettingsFile.GLOBAL) {
            value = Settings.getLegacyGlobalProperty(props, name);
        }
        if (value == null && file == SettingsFile.GLOBAL && (props = PROPERTIES_BY_FILE.get((Object)SettingsFile.GLOBAL_DEFAULT)) != null && (value = props.getProperty(name)) == null) {
            value = Settings.getLegacyGlobalProperty(props, name);
        }
        return value;
    }

    private static @Nullable String getLegacyGlobalProperty(Properties props, String name) {
        switch (name) {
            case "topics": {
                return props.getProperty("groups");
            }
            case "groups": {
                return props.getProperty("topics");
            }
            case "customFolder": {
                return props.getProperty("globalTemplate");
            }
            case "globalTemplate": {
                return props.getProperty("customFolder");
            }
        }
        return null;
    }

    public static String getString(SettingsFile file, String name, String def) {
        String value = Settings.get(file, name);
        if (value == null) {
            value = def;
        }
        return value;
    }

    public static boolean getBoolean(SettingsFile file, String name, boolean def) {
        String value = Settings.get(file, name);
        if (def) {
            return !"false".equals(value);
        }
        return "true".equals(value);
    }

    public static int getInt(SettingsFile file, String name, int def) {
        String value = Settings.get(file, name);
        if (value != null && !value.isEmpty()) {
            try {
                return Integer.parseInt(Settings.normalizeNumber(value));
            }
            catch (NumberFormatException ex) {
                LOGGER.error("Expected a number for property '{}' in '{}' but got {}", new Object[]{name, file, value});
            }
        }
        return def;
    }

    public static long getLong(SettingsFile file, String name, long def) {
        String value = Settings.get(file, name);
        if (value != null && !value.isEmpty()) {
            try {
                return Long.parseLong(Settings.normalizeNumber(value));
            }
            catch (NumberFormatException ex) {
                LOGGER.error("Expected a number for property '{}' in '{}' but got {}", new Object[]{name, file, value});
            }
        }
        return def;
    }

    public static Properties getProperties(SettingsFile file) {
        Properties p = PROPERTIES_BY_FILE.get((Object)file);
        if (p == null) {
            p = new Properties();
        }
        return p;
    }

    public static String getContextPath() {
        String cp = contextPath;
        if (cp == null) {
            throw new IllegalStateException("Context path has not been set.");
        }
        return cp;
    }

    public static void setContextPath(String path) {
        contextPath = path;
    }

    public static String getDocumentPath() {
        Object documentFolder;
        String realPath = Settings.getContextPath();
        if (realPath.endsWith(File.separator)) {
            realPath = realPath.substring(0, realPath.length() - File.separator.length());
        }
        if ((documentFolder = GlobalSettings.get("documentFolder")) == null) {
            int i = realPath.lastIndexOf(File.separator);
            documentFolder = realPath.substring(0, i) + File.separator + "documents";
        }
        return documentFolder;
    }

    public static int getServerPort() {
        String port = GlobalSettings.get("webSitePort");
        if (port == null) {
            throw new IllegalStateException("`webSitePort` is not defined");
        }
        return Integer.parseInt(port);
    }

    public static String getServerScheme() {
        String scheme = GlobalSettings.get("webSiteScheme");
        if (scheme == null) {
            throw new IllegalStateException("`webSiteScheme` is not defined");
        }
        return scheme;
    }

    public static String getServerHost() {
        String host = GlobalSettings.get("webSiteAddress");
        if (host == null) {
            throw new IllegalStateException("`webSiteAddress` is not defined");
        }
        return host;
    }

    public static int getDocumentPort() {
        return 80;
    }

    public static String getDocumentScheme() {
        return "http";
    }

    public static ServletContext getServletContext() {
        ServletContext sc = servletContext;
        if (sc == null) {
            throw new IllegalStateException("Servlet context has not been set.");
        }
        return sc;
    }

    public static void init(ServletContext context, boolean loadDbSettings) {
        servletContext = context;
        Object cp = context.getRealPath("/");
        if (cp == null) {
            throw new IllegalStateException("The context path must resolve to a non-null value");
        }
        if (!((String)cp).endsWith(File.separator)) {
            cp = (String)cp + File.separator;
        }
        contextPath = cp;
        Settings.load(SettingsFile.GLOBAL_DEFAULT, (String)cp);
        Settings.load(SettingsFile.GLOBAL, (String)cp);
        Settings.load(SettingsFile.MIME, (String)cp);
        Settings.load(SettingsFile.INDEX, (String)cp);
        if (loadDbSettings) {
            Settings.load(SettingsFile.DATABASE, (String)cp);
            DatabaseSettings.loadPassword();
            Settings.load(SettingsFile.JDO, (String)cp);
        }
        Settings.load(SettingsFile.PROJECT_DEFAULT, (String)cp);
        Settings.load(SettingsFile.GROUP_DEFAULT, (String)cp, SettingsFile.PROJECT_DEFAULT);
        File f = new File(contextPath, "WEB-INF/config/" + SettingsFile.GROUP.filename());
        if (f.exists()) {
            Settings.load(SettingsFile.GROUP, (String)cp, SettingsFile.GROUP_DEFAULT);
        } else {
            PROPERTIES_BY_FILE.put(SettingsFile.GROUP, Settings.getProperties(SettingsFile.GROUP_DEFAULT));
        }
        String globalTemplate = Settings.get(SettingsFile.GLOBAL, "globalTemplate");
        if (!Strings.isEmpty(globalTemplate)) {
            Properties customProps = Settings.loadOther(SettingsFile.PROJECT, globalTemplate);
            Settings.getProperties(SettingsFile.GROUP).putAll((Map<?, ?>)customProps);
            Settings.getProperties(SettingsFile.PROJECT_DEFAULT).putAll((Map<?, ?>)customProps);
        }
    }

    public static @Nullable Enumeration<Object> keys(SettingsFile file) {
        Properties props = PROPERTIES_BY_FILE.get((Object)file);
        if (props == null) {
            return null;
        }
        return props.keys();
    }

    public static Set<String> keySet(SettingsFile file) {
        Properties props = PROPERTIES_BY_FILE.get((Object)file);
        return props != null ? props.keySet().stream().map(Object::toString).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public static boolean isDefined(SettingsFile file) {
        return PROPERTIES_BY_FILE.containsKey((Object)file);
    }

    public static void load(SettingsFile file, String contextpath) {
        Settings.load(file, contextpath, (Properties)null);
    }

    public static void load(SettingsFile file, String contextpath, @Nullable SettingsFile defaultFile) {
        Settings.load(file, contextpath, defaultFile == null ? null : Settings.getProperties(defaultFile));
    }

    public static void load(SettingsFile file, String contextpath, @Nullable Properties defaultProps) {
        Properties props = new Properties();
        if (defaultProps != null) {
            props.putAll((Map<?, ?>)defaultProps);
        }
        StringBuilder comments = new StringBuilder();
        try {
            File f = new File(contextpath + "WEB-INF" + File.separator + Settings.configDirectory(file) + File.separator + file.filename());
            try (FileInputStream in = new FileInputStream(f);){
                props.load(in);
            }
            try (BufferedReader r = new BufferedReader(new FileReader(f));){
                String line;
                int lineNumber = 1;
                String separator = System.getProperty("line.separator", "\n");
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#") && lineNumber > 2) {
                        comments.append(line).append(separator);
                    }
                    ++lineNumber;
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error("Unable to read properties file", (Throwable)ex);
        }
        PROPERTIES_BY_FILE.put(file, props);
        COMMENTS_BY_FILE.put(file, comments.toString());
    }

    private static String configDirectory(SettingsFile file) {
        if (SettingsFile.GROUP == file || SettingsFile.DATABASE == file || SettingsFile.GLOBAL == file || SettingsFile.TEMPLATE == file) {
            return "config";
        }
        return "sysconfig";
    }

    private static Properties loadOther(SettingsFile file, String template) {
        Properties props = new Properties();
        try {
            File f = Settings.descendantFile(new File(contextPath), "WEB-INF" + File.separator + "config" + File.separator + "template" + File.separator + template + File.separator + "config" + File.separator + file.filename());
            if (!f.exists() || !f.isFile()) {
                return props;
            }
            try (FileInputStream in = new FileInputStream(f);){
                props.load(in);
            }
        }
        catch (IOException ex) {
            LOGGER.error("Unable to read properties file", (Throwable)ex);
        }
        return props;
    }

    public static File descendantFile(File base, String path) throws IOException {
        File descendant = new File(base, path);
        if (!descendant.getCanonicalPath().startsWith(base.getCanonicalPath())) {
            LOGGER.error("Path results in a file outside base folder: {}", (Object)path);
            throw new IOException("Path results in a file outside base folder");
        }
        return descendant;
    }

    public static void remove(SettingsFile file, String name) {
        Properties props = PROPERTIES_BY_FILE.get((Object)file);
        if (props != null) {
            props.remove(name);
        }
    }

    public static void removeBackupDatabaseSettings() {
        File dir = new File(contextPath + "WEB-INF" + File.separator + "config" + File.separator);
        File[] files = dir.listFiles();
        if (files != null) {
            String dbPropName = SettingsFile.DATABASE.filename();
            for (File file : files) {
                if (!file.getName().endsWith(dbPropName) || file.getName().equals(dbPropName) || file.delete()) continue;
                LOGGER.error("Unable to delete backup config file: {}", (Object)file.getName());
            }
        } else {
            LOGGER.error("Unable to list files in config folder!");
        }
    }

    public static void mergeTemplateWithGlobalSettings() {
        File rf;
        String folder = contextPath + "WEB-INF" + File.separator + Settings.configDirectory(SettingsFile.TEMPLATE);
        File f = new File(folder + File.separator + SettingsFile.TEMPLATE.filename());
        if (!f.exists() && (rf = new File(folder + File.separator + SettingsFile.TEMPLATE.filename() + ".rpmsave")).exists()) {
            rf.renameTo(f);
        }
        if (f.exists()) {
            Settings.load(SettingsFile.TEMPLATE, contextPath, PROPERTIES_BY_FILE.get((Object)SettingsFile.GLOBAL));
            PROPERTIES_BY_FILE.put(SettingsFile.GLOBAL, PROPERTIES_BY_FILE.get((Object)SettingsFile.TEMPLATE));
            COMMENTS_BY_FILE.put(SettingsFile.GLOBAL, COMMENTS_BY_FILE.get((Object)SettingsFile.GLOBAL) + "\n" + COMMENTS_BY_FILE.get((Object)SettingsFile.TEMPLATE));
            Settings.set(SettingsFile.GLOBAL, "groups", Settings.get(SettingsFile.GLOBAL, "topics"));
            Settings.remove(SettingsFile.GLOBAL, "topics");
            String customFolder = Settings.get(SettingsFile.GLOBAL, "customFolder");
            if (!Strings.isEmpty(customFolder)) {
                Settings.set(SettingsFile.GLOBAL, "globalTemplate", customFolder);
                Settings.remove(SettingsFile.GLOBAL, "customFolder");
            }
            Settings.save(SettingsFile.GLOBAL);
            if (!f.delete()) {
                LOGGER.error("Unable to delete template.properties");
            }
            if (customFolder != null) {
                Properties customProps = Settings.loadOther(SettingsFile.PROJECT, customFolder);
                Settings.getProperties(SettingsFile.GROUP).putAll((Map<?, ?>)customProps);
                Settings.getProperties(SettingsFile.PROJECT_DEFAULT).putAll((Map<?, ?>)customProps);
            }
        }
    }

    public static void set(SettingsFile filename, String name, String value) {
        Properties props = PROPERTIES_BY_FILE.computeIfAbsent(filename, key -> new Properties());
        props.setProperty(name, value);
    }

    public static void save(SettingsFile file) {
        Object basePath = Settings.getContextPath();
        String realPath = (String)(basePath = (String)basePath + "WEB-INF" + File.separator + Settings.configDirectory(file) + File.separator) + file.filename();
        File currentFile = new File(realPath);
        if (currentFile.exists()) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            df.setTimeZone(TimeZone.getDefault());
            String timeStamp = df.format(new Date());
            String archFilename = timeStamp + "-" + file.filename();
            File f = null;
            int max = 100;
            for (int j = 1; j < 100 && (f = new File((String)basePath + archFilename)).exists(); ++j) {
                archFilename = timeStamp + "-" + j + "-" + file.filename();
            }
            if (f.exists() && !f.delete()) {
                LOGGER.error("Failed to delete properties file {}", (Object)f.getAbsolutePath());
            }
            if (!currentFile.renameTo(f)) {
                LOGGER.error("Failed to delete properties file {}", (Object)realPath);
            }
        }
        Properties props = PROPERTIES_BY_FILE.get((Object)file);
        String comments = COMMENTS_BY_FILE.get((Object)file);
        if (props == null) {
            props = new Properties();
        }
        try (FileOutputStream out = new FileOutputStream(realPath);){
            props.store(out, "PageSeeder " + file.filenameNoExtension() + " settings");
            if (comments != null && !comments.isEmpty()) {
                ((OutputStream)out).write(comments.getBytes());
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to save properties file", (Throwable)ex);
        }
    }

    public static @Nullable String getPageSeederVersion() {
        Package p = Settings.class.getClassLoader().getDefinedPackage("com.pageseeder");
        return p != null ? p.getImplementationVersion() : "unknown";
    }

    static String normalizeNumber(String value) {
        Object normalised = value.replace("_", "");
        if (((String)normalised).endsWith("G")) {
            normalised = ((String)normalised).substring(0, ((String)normalised).length() - 1) + "000000000";
        } else if (((String)normalised).endsWith("M")) {
            normalised = ((String)normalised).substring(0, ((String)normalised).length() - 1) + "000000";
        } else if (((String)normalised).endsWith("K")) {
            normalised = ((String)normalised).substring(0, ((String)normalised).length() - 1) + "000";
        }
        return normalised;
    }
}

