/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.properties.GlobalSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class TemplateFactory {
    private TemplateFactory() {
    }

    public static Collection<Template> available(File webapp) {
        ArrayList<Template> available = new ArrayList<Template>();
        Set<String> names = TemplateFiles.available(webapp);
        for (String name : names) {
            Template template = new Template(name);
            available.add(template);
        }
        return available;
    }

    public static List<Template> getChain(Template template) {
        ArrayList<Template> chain = new ArrayList<Template>();
        chain.add(template);
        if (!template.isDefault()) {
            String globalTemplate = GlobalSettings.getGlobalTemplate();
            if (globalTemplate != null && !Template.isDefault(globalTemplate) && !template.name().equals(globalTemplate)) {
                chain.add(new Template(globalTemplate));
            }
            chain.add(Template.DEFAULT);
        }
        return chain;
    }

    public static @Nullable Template forLocation(@Nullable String location) {
        Pattern[] patterns;
        if (location == null) {
            return null;
        }
        for (Pattern p : patterns = new Pattern[]{Pattern.compile("/?WEB-INF/config/template/([^/]+)/.*"), Pattern.compile("/?WEB-INF/template/([^/]+)/.*"), Pattern.compile("/?woconfig/([^/]+)/.*"), Pattern.compile("/?weborganic/.*")}) {
            Template template = TemplateFactory.forLocation(location, p);
            if (template == null) continue;
            return template;
        }
        return null;
    }

    private static @Nullable Template forLocation(String location, Pattern p) {
        Matcher m = p.matcher(location);
        if (m.matches()) {
            if (m.groupCount() == 0) {
                return Template.DEFAULT;
            }
            String template = m.group(1);
            return new Template(template);
        }
        return null;
    }
}

