/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import com.pageseeder.common.util.FastKey;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class Template
implements FastKey,
Comparable<Template> {
    private static final Pattern VALID_NAME = Pattern.compile("^[a-zA-Z_][\\w!$=`{}~^-]{0,100}$");
    public static final String DEFAULT_TEMPLATE = "default";
    public static final Template DEFAULT = new Template("default");
    private final String name;

    public Template(String name) {
        this.name = Objects.requireNonNull(name, "Template must be specified");
        if (!Template.isValidName(name)) {
            throw new IllegalArgumentException("Invalid template name");
        }
    }

    public String name() {
        return this.name;
    }

    public boolean isDefault() {
        return Template.isDefault(this.name);
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template k = (Template)o;
        return this.name.equals(k.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Template o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return this.name;
    }

    public static boolean isValidName(@Nullable String name) {
        return name != null && VALID_NAME.matcher(name).matches();
    }

    public static boolean isDefault(@Nullable String name) {
        return name == null || name.isEmpty() || DEFAULT_TEMPLATE.equals(name);
    }

    public static boolean equals(@Nullable Template a, @Nullable Template b) {
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

