/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.Nullable;

public final class Resource {
    private final File file;
    private byte @Nullable [] content = null;

    public Resource(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public byte @Nullable [] getContent() {
        return this.content;
    }

    public InputStream streamContent() throws IOException {
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        return new FileInputStream(this.file);
    }

    public void setContent(byte[] binaryContent) {
        this.content = binaryContent;
    }

    public boolean loadContent() {
        int length = (int)this.file.length();
        boolean ok = true;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.file), 2048);){
            int n;
            byte[] b = new byte[length];
            for (int pos = 0; pos < length && (n = ((InputStream)is).read(b, pos, length - pos)) >= 0; pos += n) {
            }
            this.content = b;
        }
        catch (IOException ex) {
            ok = false;
        }
        return ok;
    }
}

