/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.http;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public class HttpWebRequest {
    protected final HttpServletRequest req;
    protected final HttpServletResponse res;
    protected int status = 200;

    public HttpWebRequest(HttpServletRequest req, HttpServletResponse res) {
        this.req = req;
        this.res = res;
    }

    public final HttpServletRequest request() {
        return this.req;
    }

    public final HttpServletResponse response() {
        return this.res;
    }

    public final @Nullable String getParameter(String name) {
        return this.req.getParameter(name);
    }

    public final @Nullable String getParameter(String name, boolean required) throws IOException {
        String value = this.req.getParameter(name);
        if (required && (value == null || value.isEmpty())) {
            this.sendError(400, HttpWebRequest.toMissingMessage(name, value));
            return null;
        }
        return value;
    }

    public final String getParameter(String name, String def) {
        String value = this.req.getParameter(name);
        return value != null ? value : def;
    }

    public final @Nullable Long getLongParameter(String name, boolean required, @Nullable Long def) throws IOException {
        String value = this.req.getParameter(name);
        if (value == null || value.isEmpty()) {
            if (required) {
                this.sendError(400, HttpWebRequest.toMissingMessage(name, value));
                return null;
            }
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            this.sendError(400, "Long parameter '" + name + "' is not a valid number");
            return def;
        }
    }

    public final boolean getBooleanParameter(String name, boolean def) {
        String value = this.req.getParameter(name);
        if (value == null || value.isEmpty()) {
            return def;
        }
        if (def) {
            return "false".equals(value) || "no".equals(value);
        }
        return "true".equals(value) || "yes".equals(value);
    }

    public final @Nullable Long getLongParameter(String name, boolean required) throws IOException {
        return this.getLongParameter(name, required, null);
    }

    public void sendError(int code, Exception ex) throws IOException {
        if (this.hasError()) {
            return;
        }
        this.status = code;
        if (code == 500) {
            this.req.setAttribute("javax.servlet.error.request_uri", (Object)this.req.getRequestURI());
            this.req.setAttribute("javax.servlet.error.exception", (Object)ex);
        }
        this.res.sendError(code, ex.getMessage());
    }

    public void sendErrorSilently(int code, Exception ex) {
        try {
            this.sendError(code, ex);
        }
        catch (IOException io) {
            HttpWebRequest.swallow(io);
        }
    }

    public void sendError(int code, String message) throws IOException {
        if (this.hasError()) {
            return;
        }
        this.status = code;
        this.res.sendError(code, message);
    }

    public void sendErrorSilently(int code, String message) {
        try {
            this.sendError(code, message);
        }
        catch (IOException io) {
            HttpWebRequest.swallow(io);
        }
    }

    public final boolean hasError() {
        int start_http_error_code = 400;
        return this.status >= 400;
    }

    public final int getStatus() {
        return this.status;
    }

    private static String toMissingMessage(String name, @Nullable String value) {
        return "Parameter '" + name + "' is required; but value was " + (value != null ? "\"\" (empty string)" : "null");
    }

    private static void swallow(IOException ex) {
        LoggerFactory.getLogger(HttpWebRequest.class).error("Swallowed IO exception while trying to send error", (Throwable)ex);
    }
}

